package ride_s

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-user/_const/enum/property_e"
	"hilo-user/domain/model/user_m"
	"time"
)

type RideService struct {
	svc *domain.Service
}

func NewRideService(myContext *mycontext.MyContext) *RideService {
	svc := domain.CreateService(myContext)
	return &RideService{svc}
}

// 下发座驾
func (s *RideService) SendRide(receiverUserId mysql.ID, rideId mysql.ID, days int) error {
	model := domain.CreateModelContext(s.svc.MyContext)
	// 增加座驾
	receivePropertyDuration := uint32(days) * 3600 * 24
	userProperty, err := user_m.GetUserPropertyOrInit(model, receiverUserId, rideId)
	if err != nil {
		return err
	}
	nowTime := time.Now()
	if userProperty.EndTime.After(nowTime) {
		nowTime = userProperty.EndTime
	}
	userProperty.EndTime = nowTime.Add(time.Duration(receivePropertyDuration) * time.Second)
	if err := userProperty.Persistent(); err != nil {
		return err
	}
	//日志错误，并不事务回调
	if err := (&user_m.UserPropertyLog{
		Model:         model,
		UserId:        receiverUserId,
		PropertyId:    rideId,
		OriginType:    property_e.ActivityBillboardTrigger,
		Type:          property_e.AddSecond,
		AddSecond:     &receivePropertyDuration,
		UpdateEndTime: nil,
	}).Persistent(); err != nil {
		model.Log.Error(err)
	}
	return nil
}
