package cp_e

import "git.hilo.cn/hilo-common/resource/mysql"

const (
	EffectDays = 30 // 30天有效期
)

type CpLevel int

const (
	CpLevel0 CpLevel = 0 // 无称号
	CpLevel1 CpLevel = 1 // 恋爱CP
	CpLevel2 CpLevel = 2 // 甜蜜CP
	CpLevel3 CpLevel = 3 // 忠诚CP
	CpLevel4 CpLevel = 4 // 炽热CP
	CpLevel5 CpLevel = 5 // 荣耀CP

	CpLevelMax = CpLevel5
)

var (
	// cp等级积分
	CpLevelPoints = map[CpLevel]mysql.Num{
		CpLevel0: 0,
		CpLevel1: 200000,
		CpLevel2: 800000,
		CpLevel3: 1000000,
		CpLevel4: 3000000,
		CpLevel5: 10000000,
	}
	// cp等级icon // todo ui
	CpLevelIcon = map[CpLevel]string{
		CpLevel0: "icon0.png",
		CpLevel1: "icon1.png",
		CpLevel2: "icon2.png",
		CpLevel3: "icon3.png",
		CpLevel4: "icon4.png",
		CpLevel5: "icon5.png",
	}
	// cp特权名称 // todo 翻译
	CpPrivilegeNameMsgId = map[CpPrivilege]uint{
		CpPrivilegeSpace:         0,
		CpPrivilegeBanner:        0,
		CpPrivilegeMedal:         0,
		CpPrivilegeCert:          0,
		CpPrivilegeRoomEffect:    0,
		CpPrivilegeHeadwear:      0,
		CpPrivilegeActiveProfile: 0,
		CpPrivilegeMicEffect:     0,
	}
	// cp特权描述 // todo 翻译
	CpPrivilegeDescMsgId = map[CpPrivilege]uint{
		CpPrivilegeSpace:         0,
		CpPrivilegeBanner:        0,
		CpPrivilegeMedal:         0,
		CpPrivilegeCert:          0,
		CpPrivilegeRoomEffect:    0,
		CpPrivilegeHeadwear:      0,
		CpPrivilegeActiveProfile: 0,
		CpPrivilegeMicEffect:     0,
	}
	// cp特权icon // todo ui
	CpPrivilegeIcon = map[CpPrivilege]string{
		CpPrivilegeSpace:         "icon_p_1.png",
		CpPrivilegeBanner:        "icon_p_2.png",
		CpPrivilegeMedal:         "icon_p_3.png",
		CpPrivilegeCert:          "icon_p_4.png",
		CpPrivilegeRoomEffect:    "icon_p_5.png",
		CpPrivilegeHeadwear:      "icon_p_6.png",
		CpPrivilegeActiveProfile: "icon_p_7.png",
		CpPrivilegeMicEffect:     "icon_p_8.png",
	}
)

type CpPrivilege int

const (
	CpPrivilegeSpace         CpPrivilege = 1 // 空间
	CpPrivilegeBanner        CpPrivilege = 2 // 横幅
	CpPrivilegeMedal         CpPrivilege = 3 // 等级勋章
	CpPrivilegeCert          CpPrivilege = 4 // 证书
	CpPrivilegeRoomEffect    CpPrivilege = 5 // 进场特效
	CpPrivilegeHeadwear      CpPrivilege = 6 // 头像头饰
	CpPrivilegeActiveProfile CpPrivilege = 7 // 动态资料卡
	CpPrivilegeMicEffect     CpPrivilege = 8 // 麦位特效
)
