package cp_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"github.com/robfig/cron"
	"hilo-user/domain/model/cp_m"
)

func ClearCpExpire() {
	c := cron.New()
	spec := "0 0 */1 * * ?"
	if !config.AppIsRelease() {
		spec = "0 * * * * ?"
	}
	// 1小时清理一次
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		if err := cp_m.ClearExpireCpPoints(model); err != nil {
			model.Log.Errorf("ClearExpireCpPoints fail:%v", err)
		}
	})
	c.Start()
}
