package cp_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/_const/enum/cp_e"
)

// svip特权
type CpPrivilege struct {
	mysql.Entity
	UserId    mysql.ID
	Type      cp_e.CpPrivilege
	OpenClose mysql.OpenClose
}

// 开关用于svip特权
func OpenCLoseUserSvipPrivilege(model *domain.Model, userId mysql.ID, Type cp_e.CpPrivilege, openClose mysql.OpenClose) error {
	var pri CpPrivilege
	if err := model.DB().Model(CpPrivilege{}).Where("user_id = ? AND `type` = ?", userId, Type).
		First(&pri).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			return err
		}
		// record not found
		return model.DB().Create(&CpPrivilege{
			UserId:    userId,
			Type:      Type,
			OpenClose: openClose,
		}).Error
	}
	// update
	return model.DB().Model(CpPrivilege{}).Where("user_id = ? AND `type` = ?", userId, Type).
		UpdateColumn("open_close", openClose).Error
}

// 批量获取用户svip特权开关
// map userId->type->open
func MGetUserSvipPrivilege(model *domain.Model, userIds []mysql.ID) (map[mysql.ID]map[cp_e.CpPrivilege]bool, error) {
	res := make(map[mysql.ID]map[cp_e.CpPrivilege]bool)
	var privileges []CpPrivilege
	if err := model.DB().Model(CpPrivilege{}).Where("user_id in ? AND open_close = ?", userIds, mysql.OPEN).Find(&privileges).Error; err != nil {
		return res, err
	}
	for _, v := range privileges {
		if data, ok := res[v.UserId]; ok {
			data[v.Type] = true
		} else {
			res[v.UserId] = make(map[cp_e.CpPrivilege]bool)
			res[v.UserId][v.Type] = true
		}
	}
	return res, nil
}
