package msg_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/myerr"
)

func GetMsgSysRecordInit(model *domain.Model, t uint32, msgSysId uint64) *MsgSysRecord {
	return &MsgSysRecord{
		Model:    model,
		Type:     t,
		Status:   mysql.EXIST,
		MsgSysId: msgSysId,
	}
}

func GetMsgSysRecord(model *domain.Model, msgSysId uint64) (*MsgSysRecord, error) {
	msgSysRecord := MsgSysRecord{}
	if err := model.Db.Model(&MsgSysRecord{}).Where(&MsgSysRecord{
		MsgSysId: msgSysId,
	}).First(&msgSysRecord).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	} else {
		msgSysRecord.Model = model
		return &msgSysRecord, nil
	}
}
