package main

import (
	"fmt"
	"git.hilo.cn/hilo-common/resource/consul"
	"hilo-user/cron"
	"hilo-user/domain/service/event_s"
	"hilo-user/route"
)

const (
	PORT         = 9040
	RegisterName = "hiloUser"
	RegisterTag  = "用户中心"
)

func main() {
	cron.Init()                                              // 开启定时任务
	event_s.EventInit()                                      // 注册事件(内部事件+mysql拟kafka)
	r := route.InitRouter()                                  // 注册路由
	consul.RegisterToConsul(PORT, RegisterName, RegisterTag) // 服务注册
	r.Run(fmt.Sprintf(":%d", PORT))                          // 启动服务
}
