package cp_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
	"time"
)

type CpVisitor struct {
	CpId        mysql.ID
	UserId1     mysql.ID
	UserId2     mysql.ID
	Visitor     mysql.ID
	Times       mysql.Num
	CreatedTime time.Time `gorm:"->"`
	UpdatedTime time.Time `gorm:"->"`
}

// 添加cp空间访问量
func AddCpSpaceVisitor(model *domain.Model, cpId, userId1, userId2, visitor mysql.ID) error {
	vis := &CpVisitor{
		CpId:    cpId,
		UserId1: userId1,
		UserId2: userId2,
		Visitor: visitor,
		Times:   1,
	}
	if err := model.DB().Model(CpVisitor{}).Clauses(clause.OnConflict{Columns: []clause.Column{{Name: "cp_id"}, {Name: "visitor"}},
		DoUpdates: clause.Assignments(map[string]interface{}{
			"times": gorm.Expr("times + ?", 1)})}).Create(vis).Error; err != nil {
		model.Log.Errorf("AddCpSpaceVisitor fail:%v", err)
		return err
	}
	return nil
}

// 获取cp空间访问人数
func CountCpSpaceVisitors(model *domain.Model, cpId mysql.ID) int64 {
	var cnt int64
	if err := model.DB().Model(CpVisitor{}).Where("cp_id = ?", cpId).Count(&cnt).Error; err != nil {
		model.Log.Errorf("CountCpSpaceVisitors fail:%v", err)
	}
	return cnt
}
