package event_s

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-user/_const/enum/cp_e"
	"hilo-user/domain/event/cp_ev"
	"hilo-user/domain/model/cp_m"
	"hilo-user/myerr/bizerr"
)

// cp空间访问
func CpSpaceVisitEvent() {
	cp_ev.AddCpSpaceVisitAsync(func(model *domain.Model, event interface{}) error {
		e, ok := event.(*cp_ev.SpaceVisitEvent)
		if !ok {
			return bizerr.InvalidParameter
		}
		if err := cp_m.AddCpSpaceVisitor(model, e.CpId, e.UserId1, e.UserId2, e.UserId); err != nil {
			model.Log.Errorf("AddCpSpaceVisitor fail:%v", err)
		}
		if cnt := cp_m.CountCpSpaceVisitors(model, e.CpId); cnt > 0 {
			if err := cp_m.UpdateCpAchievement(model, e.CpId, e.UserId1, e.UserId2, cp_e.CpAchievementVisitors, mysql.Num(cnt)); err != nil {
				model.Log.Errorf("UpdateCpAchievement fail:%v", err)
			}
		}
		return nil
	})
}
