package event_s

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"github.com/pkg/errors"
	"hilo-user/_const/enum/msg_e"
	"hilo-user/_const/enum/res_e"
	"hilo-user/domain/event/user_ev"
	"hilo-user/domain/model/msg_m"
	"hilo-user/domain/model/res_m"
	"hilo-user/domain/model/user_m"
)

func EventInit() {
	UserBagSendEvent()
	CpGiftEvent()
	CpSpaceVisitEvent()
}

func UserBagSendEvent() {
	user_ev.AddUserBagSendAsync(func(model *domain.Model, event interface{}) error {
		e, ok := event.(*user_ev.UserBagSendEvent)
		if !ok {
			return errors.New("AddUserBagSendAsync param fail")
		}
		if e.ResType != res_e.ResUserBagGift {
			return nil
		}
		user, err := user_m.GetUser(model, e.UserId)
		if err != nil {
			return err
		}
		gift, err := res_m.FindResGift(model, e.ResId)
		if err != nil {
			return err
		}
		if err := msg_m.NewUserRecord(model, e.UserId, msg_e.AddUserBag,
			gift.Name, 0, "", fmt.Sprintf("%d", e.Day),
			"", "", "").Persistent(); err != nil {
			model.Log.Errorf("NewUserRecord fail")
		} else {
			msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType)
		}
		return nil
	})
}
