package user_k

import (
	"fmt"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-user/_const/redis_key"
	"strconv"
	"strings"
)

const (
	UserPrefix             = "user:"
	UserTinyInfoStr        = UserPrefix + "tiny:${userId}"           // value:json(cv.CvUserTiny)
	UserExternalIdToUIdStr = UserPrefix + "externalId:${externalId}" // value:userId
	UserCodeToUIdStr       = UserPrefix + "code:${externalId}"       // value:userId
	UserTradeUnionIds      = "user:trade:union:ids"                  // type:string,value json(uids)
)

// 获取用户简要信息缓存key
func GetUserTinyKey(userId mysql.ID) string {
	return redis_key.ReplaceKey(UserTinyInfoStr, fmt.Sprintf("%d", userId))
}

// 获取externalId到userId
func GetExternalIdToUidKey(externalId mysql.Str) string {
	return redis_key.ReplaceKey(UserExternalIdToUIdStr, externalId)
}

// 获取code到userId
func GetCodeToUidKey(code mysql.Str) string {
	return redis_key.ReplaceKey(UserCodeToUIdStr, code)
}

const syncTimHiloLock = "sync_tim_hilo_{userId}"

func GetKeySyncTimHilo(userId uint64) string {
	return strings.Replace(syncTimHiloLock, "{userId}", strconv.FormatUint(userId, 10), -1)
}
