package bizerr

import (
	"hilo-user/myerr"
)

var (
	// 一般性错误
	TokenInvalid      = myerr.NewBusinessCode(1001, "token invalid", myerr.BusinessData{})
	ExternalIdNoExist = myerr.NewBusinessCode(1003, "externalId no exist", myerr.BusinessData{})
	CodeNoExist       = myerr.NewBusinessCode(1005, "code no exist", myerr.BusinessData{})
	ParaMissing       = myerr.NewBusinessCode(1006, "parameter missing", myerr.BusinessData{})
	InvalidParameter  = myerr.NewBusinessCode(1009, "Invalid parameter", myerr.BusinessData{})
	IncorrectState    = myerr.NewBusinessCode(1013, "Incorrect state", myerr.BusinessData{})
	TransactionFailed = myerr.NewBusinessCode(1014, "Transaction failed", myerr.BusinessData{})
	ReqTooFrequent    = myerr.NewBusinessCode(1018, "Requests are too frequent", myerr.BusinessData{})

	// 钻石
	DiamondNoEnough      = myerr.NewBusinessCode(4000, "Insufficient diamonds", myerr.BusinessData{})
	DiamondFrequency     = myerr.NewBusinessCode(4001, "Diamond operation frequency too high", myerr.BusinessData{})
	DiamondAccountFrozen = myerr.NewBusinessCode(4004, "Diamond Account Frozen", myerr.BusinessData{})

	// 游戏
	GameInvalidParameter = myerr.NewGameError(10002, "invalid parameter")
	GameTokenInvalid     = myerr.NewGameError(1004, "user token invalid")
	GameTokenExpire      = myerr.NewGameError(1005, "user token expire")

	// 群组
	GroupNotFound = myerr.NewBusinessCode(14001, "Group not found", myerr.BusinessData{}) // 找不到该群

	// 游戏服务的错误码，6位，50XXX
	GameAddNoPermissions  = myerr.NewBusinessCode(50100, "Only room administrators can create users", myerr.BusinessData{})                // 权限不足
	GameAddNotOnMic       = myerr.NewBusinessCode(50101, "Need on mic", myerr.BusinessData{})                                              // 需要在麦上才能创建、加入游戏
	GameHaveNoEnd         = myerr.NewBusinessCode(50102, "Group user have no end", myerr.BusinessData{})                                   // 房间还有未结束的游戏
	GameNotFound          = myerr.NewBusinessCode(50103, "Game not found", myerr.BusinessData{})                                           //
	GameStart             = myerr.NewBusinessCode(50104, "Gaming", myerr.BusinessData{})                                                   //
	GameAlreadyJoin       = myerr.NewBusinessCode(50105, "Already Joined", myerr.BusinessData{})                                           // 已经加入了游戏
	GameNotJoin           = myerr.NewBusinessCode(50106, "Not Join user", myerr.BusinessData{})                                            // 还未加入游戏
	GameCannotClose       = myerr.NewBusinessCode(50107, "Have no power to close user", myerr.BusinessData{})                              // 没有权限关闭游戏
	GameCloseGaming       = myerr.NewBusinessCode(50108, "Can't close a user in progress", myerr.BusinessData{})                           // 不能关闭进行中的游戏
	GamePlayerNumWrong    = myerr.NewBusinessCode(50109, "Game player num wrong", myerr.BusinessData{})                                    // 玩家数量错误
	GameHaveNoMyRoom      = myerr.NewBusinessCode(50110, "Have no my room", myerr.BusinessData{})                                          // 自己没有房间
	GameHaveNoEndGame     = myerr.NewBusinessCode(50111, "The last user is not over yet, cannot create/join a user", myerr.BusinessData{}) // 已经加入了其他房间的游戏
	GameExitWrong         = myerr.NewBusinessCode(50112, "Can not exit user", myerr.BusinessData{})                                        // 离开游戏失败
	GameDiamondCannotEdit = myerr.NewBusinessCode(50113, "Game diamond can not edit", myerr.BusinessData{})                                //
	GameSettleWrong       = myerr.NewBusinessCode(50114, "Game settle wrong", myerr.BusinessData{})                                        // 结算修改错误
	GameCloseWrong        = myerr.NewBusinessCode(50115, "Game close wrong", myerr.BusinessData{})                                         // 关闭错误
	GameJoinFailed        = myerr.NewBusinessCode(50116, "Join failed", myerr.BusinessData{})                                              // 加入失败
)
