package diamond_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/domain/model"
	"hilo-user/myerr"
	"strconv"
)

func (diamondAccountDetail *DiamondAccountDetail) PersistentNoInTransactional() error {
	//fixme: 这里有点奇怪， diamondAccount持久化动作在diamondAccountDetail持久化之后，RowsAffected 就一定是0
	txDiamondAccount := diamondAccountDetail.Db.Model(diamondAccountDetail.diamondAccount)
	if diamondAccountDetail.diamondAccount.CheckUpdateCondition() {
		txDiamondAccount = txDiamondAccount.Where(diamondAccountDetail.diamondAccount.GetUpdateCondition())
	}
	if diamondAccountDetail.AddReduce == mysql.ADD {
		//增加
		txDiamondAccount.UpdateColumn("diamond_num", gorm.Expr("diamond_num + ?", diamondAccountDetail.Num))
	} else if diamondAccountDetail.AddReduce == mysql.REDUCE {
		//减少，保证不能扣成负数
		txDiamondAccount.Where("diamond_num >= ?", diamondAccountDetail.Num).UpdateColumn("diamond_num", gorm.Expr("diamond_num - ?", diamondAccountDetail.Num))
	} else {
		myerr.NewSysError("addReduce 枚举错误 value:" + mysql.TypeToString(mysql.Type(diamondAccountDetail.AddReduce)))
	}
	if err := txDiamondAccount.Error; err != nil {
		return myerr.WrapErr(err)
	}
	if txDiamondAccount.RowsAffected == 0 {
		diamondAccountDetail.Log.Errorf("gorm condition update.RowsAffected = 0，AddReduce：%v", diamondAccountDetail.AddReduce)
		return myerr.NewWaring("gorm condition update.RowsAffected = 0")
	}

	//持久化diamondAccountDetail
	if err := model.Persistent(diamondAccountDetail.Db, diamondAccountDetail); err != nil {
		return myerr.WrapErr(err)
	}
	//改变diamondAccount值
	if diamondAccountDetail.diamondAccount == nil {
		return myerr.NewSysError("持久化错误， 模型：DiamondAccountDetail 中没有diamondAccount, DiamondAccountDetail.Id =" + strconv.Itoa(int(diamondAccountDetail.ID)))
	}

	var newDiamondAccount DiamondAccount
	if err := diamondAccountDetail.Db.First(&newDiamondAccount, diamondAccountDetail.diamondAccount.ID).Error; err != nil {
		return myerr.WrapErr(err)
	}

	if newDiamondAccount.DiamondNum < 0 {
		return myerr.NewSysError("diamond_account表中，diamond_num 不能小于0, diamondAccount.id = " + strconv.Itoa(int(newDiamondAccount.ID)))
	}
	return nil
}
