CREATE TABLE `cp_relation` (
                                      `id` bigint unsigned AUTO_INCREMENT NOT NULL,
                                      `user_id1` bigint NOT NULL COMMENT 'user_id1',
                                      `user_id2` bigint NOT NULL COMMENT 'user_id2',
                                      `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                      `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                      PRIMARY KEY (`id`),
                                      UNIQUE KEY `uid1_idx` (`user_id1`) USING BTREE,
                                      UNIQUE KEY `uid2_idx` (`user_id2`) USING BTREE,
                                      KEY `ctime_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='cp关系表';

INSERT INTO hilo.diamond_operate_set (diamond_num, frequency_num, frequency_day, diamond_max_num, add_reduce, `type`, name, status, diamond_type)
VALUES (-1, -1, -1, -1, 2, 94, 'cp邀请扣费', 1, 1),
       (-1, -1, -1, -1, 1, 95, 'cp邀请退费', 1, 1);

CREATE TABLE `cp_invite` (
                             `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                             `user_id` bigint NOT NULL COMMENT '发起邀请者',
                             `invite_user_id` bigint NOT NULL COMMENT '被邀请的人',
                             `diamond_num` int unsigned NOT NULL COMMENT '邀请者花费的钻石',
                             `status` tinyint unsigned NOT NULL COMMENT '状态1.未接受2.已接受3.拒接导致退费4.过期导致退费',
                             `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                             `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                             PRIMARY KEY (`id`),
                             KEY `uid_idx` (`user_id`) USING BTREE,
                             KEY `uid2_idx` (`invite_user_id`) USING BTREE,
                             KEY `status_idx` (`status`) USING BTREE,
                             KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='cp邀请发起记录';

CREATE TABLE `cp_cancel` (
                             `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                             `user_id` bigint NOT NULL COMMENT '发起者',
                             `rec_user_id` bigint NOT NULL COMMENT '接收者',
                             `status` tinyint unsigned NOT NULL COMMENT '状态1.未处理2.发起者已撤销3.对方已确认4.到期自动确认',
                             `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                             `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                             PRIMARY KEY (`id`),
                             KEY `uid_idx` (`user_id`) USING BTREE,
                             KEY `uid2_idx` (`rec_user_id`) USING BTREE,
                             KEY `status_idx` (`status`) USING BTREE,
                             KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='cp解除发起记录';