package user_r

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"github.com/gin-gonic/gin"
	"hilo-user/_const/enum/cp_e"
	"hilo-user/_const/enum/res_e"
	"hilo-user/cv/user_cv"
	"hilo-user/domain/model/bag_m"
	"hilo-user/domain/model/res_m"
	"hilo-user/myerr/bizerr"
	"hilo-user/req"
	"hilo-user/resp"
	"strconv"
	"time"
)

// @Tags 用户背包
// @Summary 获取用户的背包
// @Param resType path int true "类型：1 礼物"
// @Success 200 {object} []user_cv.UserBag
// @Router /v1/user/bag/{resType} [get]
func UserBag(c *gin.Context) (*mycontext.MyContext, error) {
	myCtx := mycontext.CreateMyContext(c.Keys)
	userId, err := req.GetUserId(c)
	if err != nil {
		return myCtx, err
	}
	model := domain.CreateModelContext(myCtx)
	resType, err := strconv.Atoi(c.Param("resType"))
	if err != nil {
		return myCtx, err
	}
	var results []user_cv.UserBag
	switch res_e.ResUserBag(resType) {
	case res_e.ResUserBagGift:
		userBagGifts, err := bag_m.GetUserValidUserBag(model, userId, res_e.ResUserBagGift)
		if err != nil {
			return myCtx, err
		}
		allGifts, err := res_m.FindAllResGiftsMap(model)
		if err != nil {
			return myCtx, err
		}
		for _, bagGift := range userBagGifts {
			if gift, ok := allGifts[bagGift.ResId]; ok {
				info := user_cv.UserBag{
					BagId:       bagGift.ID,
					ResType:     res_e.ResUserBagGift,
					ResId:       gift.ID,
					GiftId:      gift.ID,
					Name:        gift.Name,
					DiamondNum:  gift.DiamondNum,
					IconUrl:     gift.IconUrl,
					SvgaUrl:     gift.SvagUrl,
					Count:       bagGift.Count,
					RemainDays:  int(bagGift.EndTime.Sub(time.Now()).Hours() / 24),
					HasGiftText: gift.HasGiftText,
				}
				if gift.ID == cp_e.CpConfessionGiftId || gift.HasGiftText { // 如果是cp告白礼物
					info.TextStyleList = make([]*user_cv.TextStyle, 0, 2)
					info.TextStyleList = append(info.TextStyleList,
						&user_cv.TextStyle{TextColor: "#ce0083", TextSize: 20, TextKey: "sender_name"},
						&user_cv.TextStyle{TextColor: "#ce0083", TextSize: 20, TextKey: "receiver_name"},
						&user_cv.TextStyle{TextColor: "#FFFFFF", TextSize: 40, TextKey: "gift_text"},
					)
				}

				results = append(results, info)
			}
		}
	default:
		return myCtx, bizerr.InvalidParameter
	}
	resp.ResponseOk(c, results)
	return myCtx, nil
}
