package cron

import (
	"git.hilo.cn/hilo-common/resource/config"
	"hilo-user/cron/cp_cron"
	"hilo-user/cron/gift_cron"
	"hilo-user/cron/user_cron"
)

func Init() {
	user_cron.SyncGiftRecommendUsers() // 同步送礼推荐用户,多进程都需要执行
	if !config.IsMaster() {
		return
	}
	//gift_cron.SendGiftEventInit() // 礼物消息
	//gift_cron.GiftRemark()        // 礼物消息补偿
	gift_cron.SendGiftEvent() // 送礼事件
	cp_cron.ClearCpExpire()       // 清理过期cp
	cp_cron.CpAnniversaryNotice() // cp纪念日
	cp_cron.CpInviteCancelInit()  // cp邀请、解除到期结算
}
