package cp_cron

import (
	"git.hilo.cn/hilo-common/_const/enum/diamond_e"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/config"
	"git.hilo.cn/hilo-common/utils"
	"github.com/robfig/cron"
	"hilo-user/_const/enum/cp_e"
	"hilo-user/domain/model/cp_m"
	"hilo-user/domain/model/diamond_m"
	"time"
)

// cp邀请、解除到期结算
func CpInviteCancelInit() {
	if !config.IsMaster() {
		return
	}
	mylogrus.MyLog.Infof("CpInviteCancelInit")

	// 每2min监测一次
	c := cron.New()
	spec := "0 */2 * * * *"
	if !config.AppIsRelease() {
		spec = "0 */1 * * * ?" // 测服每1分钟
	}
	_ = c.AddFunc(spec, func() {
		defer utils.CheckGoPanic()
		model := domain.CreateModelNil()
		// 获取超过24小时没被处理的cp邀请
		inviteList, err := cp_m.GetCpInviteByTime(model, time.Now().AddDate(0, 0, -1))
		if err != nil {
			model.Log.Errorf("CpInviteCancelInit err:%v", err)
			return
		}
		for _, v := range inviteList {
			model := domain.CreateModelContext(model.MyContext)
			model.Log.Infof("CpInviteCancelInit invite:%+v", v)
			err = model.Transaction(func(model *domain.Model) error {
				// 更新邀请记录
				err = cp_m.UpdateStatusCpInvite(model, v.Id, cp_e.CpInviteExpired)
				if err != nil {
					model.Log.Errorf("CpInviteCancelInit Id:%d, err:%v", v.Id, err)
					return err
				}
				// 退费
				err = diamond_m.ChangeDiamondAccountDetail(model, diamond_e.CpInviteRefund, v.Id, v.UserId, v.DiamondNum)
				if err != nil {
					model.Log.Errorf("CpInviteCancelInit Id:%d, err:%v", v.Id, err)
					return err
				}
				return nil
			})
			if err != nil {
				model.Log.Errorf("CpInviteCancelInit invite:%+v, err:%v", v, err)
				continue
			}
			time.Sleep(time.Millisecond * 10)
		}

		// 获取超过24小时没被处理的cp解除申请
		cancelList, err := cp_m.GetCpCancelByTime(model, time.Now().AddDate(0, 0, -1))
		if err != nil {
			model.Log.Errorf("CpInviteCancelInit err:%v", err)
			return
		}
		for _, v := range cancelList {
			model := domain.CreateModelContext(model.MyContext)
			model.Log.Infof("CpInviteCancelInit cancel:%+v", v)
			err = model.Transaction(func(model *domain.Model) error {
				// 更新解除记录
				err = cp_m.UpdateStatusCpCancel(model, v.Id, cp_e.CpCancelAcceptAuto)
				if err != nil {
					model.Log.Errorf("CpInviteCancelInit Id:%d, err:%v", v.Id, err)
					return err
				}
				// 删除cp关系表的记录
				err = cp_m.DelCpRelation(model, v.UserId, v.RecUserId)
				if err != nil {
					model.Log.Errorf("CpInviteCancelInit Id:%d, err:%v", v.Id, err)
					return err
				}
				return nil
			})
			if err != nil {
				model.Log.Errorf("CpInviteCancelInit cancel:%+v, err:%v", v, err)
				continue
			}
			time.Sleep(time.Millisecond * 10)
		}
	})
	c.Start()
}
