package invite_cv

import "git.hilo.cn/hilo-common/resource/mysql"

type CvUserLevel struct {
	UserId          mysql.ID `json:"userId"`          // 用户id
	WealthUserGrade uint32   `json:"wealthUserGrade"` // 财富等级
	CharmUserGrade  uint32   `json:"charmUserGrade"`  // 魅力等级
	ActiveUserGrade uint32   `json:"activeUserGrade"` // 活跃等级
	NobleLevel      uint16   `json:"nobleLevel"`      // 贵族等级
}

type InviteApplyRes struct {
	List    []*InviteApply       `json:"list"`
	NumList []*InviteApplyNumRes `json:"numList"`
	MyCode  string               `json:"myCode"`
}

type InviteApply struct {
	NewUserCode string `json:"newUserCode"`
	Platform    string `json:"platform"`
	Recharge    string `json:"recharge"`
	UserCode    string `json:"userCode"`
	CreateUnix  int64  `json:"createUnix"`
	Level       string `json:"level"`
	Status      uint8  `json:"status"` // 状态0.未审核1.已通过2.已拒绝
	Avatar      string `json:"avatar"`
	ExternalId  string `json:"externalId"`
	Reason      int    `json:"reason"` // 1.已申请2.待审核3.已通过4.已拒绝"
	Country     string `json:"country"`
	PlatformId  string `json:"platformId"`
}

type InviteApplyNumRes struct {
	Type int `json:"type"` // 1.已申请2.待审核3.已通过4.已拒绝"
	Num  int `json:"num"`
}

type AgentPeriod struct {
	Week []AgentPeriodWeek `json:"week"`
}

type AgentPeriodWeek struct {
	StartDate string `json:"startDate"`
	EndDate   string `json:"endDate"`
}
