package user_cv

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-user/cv/headwear_cv"
	"hilo-user/cv/medal_cv"
	"hilo-user/cv/property_cv"
	"time"
)

//空字符串转成nil
func StrNil(msg string) *string {
	if msg == "" {
		return nil
	}
	return &msg
}

func TypeToUint8(t *mysql.Type) *uint8 {
	if *t == 0 {
		return nil
	} else {
		return (*uint8)(t)
	}
}

func BirthdayToUint64(birthday *mysql.Timestamp) *uint64 {
	if *birthday == 0 {
		return nil
	}
	return (*uint64)(birthday)
}

func NumToUint32(num *mysql.Num) *uint32 {
	return (*uint32)(num)
}

func TimeToUint64(t *time.Time) *uint64 {
	a := uint64(t.Unix())
	return &a
}

func StrToString(str *mysql.Str) *string {
	return (*string)(str)
}

func IndexToUint16(i *mysql.Index) *uint16 {
	return (*uint16)(i)
}

func IdToUint64(id *mysql.ID) *uint64 {
	return (*uint64)(id)
}

func IsInStringList(str string, list []string) bool {
	for _, v := range list {
		if str == v {
			return true
		}
	}
	return false
}

func IfLogoutStr(condition bool, trueVal, falseVal string) string {
	if condition {
		return trueVal
	}
	return falseVal
}

func IfLogoutNick(condition bool, code string, nick string) string {
	if condition {
		return "Hilo No." + code
	}
	return nick
}
func IfLogout(logoutTime int64) bool {
	return logoutTime > 0 && time.Now().Unix() > logoutTime
}

func IfLogoutMedals(condition bool, trueVal, falseVal []uint32) []uint32 {
	if condition {
		return trueVal
	}
	return falseVal
}

func IfLogoutMedalInfo(condition bool, trueVal, falseVal []medal_cv.CvMedal) []medal_cv.CvMedal {
	if condition {
		return trueVal
	}
	return falseVal
}

func IfLogoutRide(condition bool, trueVal, falseVal property_cv.CvProperty) property_cv.CvProperty {
	if condition {
		return trueVal
	}
	return falseVal
}

func IfLogoutHeadwear(condition bool, trueVal, falseVal *headwear_cv.CvHeadwear) *headwear_cv.CvHeadwear {
	if condition {
		return trueVal
	}
	return falseVal
}
