package common

import (
	"context"
	"encoding/json"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/resource/redisCli"
	"hilo-user/_const/redis_key"
	"hilo-user/myerr"
	"time"
)

func GetUserMedalMergeCache(userId mysql.ID) ([]uint32, error) {
	bData, err := GetCache(redis_key.GetUserMedalMerge(userId))
	if err != nil {
		return nil, myerr.WrapErr(err)
	}

	res := make([]uint32, 0)
	err = json.Unmarshal(bData, &res)
	if err != nil {
		return nil, myerr.WrapErr(err)
	}
	return res, nil
}

func GetCache(key string) ([]byte, error) {
	data, err := redisCli.GetRedis().Get(context.Background(), key).Bytes()
	if err != nil {
		return nil, err
	}
	return data, nil
}

func SetCache(key string, data interface{}, expire time.Duration) error {
	jData, err := json.Marshal(data)
	if err != nil {
		return err
	}
	err = redisCli.GetRedis().Set(context.Background(), key, jData, expire).Err()
	if err != nil {
		mylogrus.MyLog.Errorf("SetCache key:%s, data:%v, err:%s", key, data, err)
		return err
	}
	return nil
}

func SetUserMedalMergeCache(userId mysql.ID, data []uint32) error {
	err := SetCache(redis_key.GetUserMedalMerge(userId), data, time.Hour*2)
	if err != nil {
		mylogrus.MyLog.Errorf("SetUserMedalMerge err:%s", err)
		return myerr.WrapErr(err)
	}
	return nil
}
