package cp_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/myerr"
)

type StatusCp = mysql.Type

const (
	Connect    StatusCp = 1
	Disconnect StatusCp = 2
)

type OldCp struct {
	mysql.Entity
	//必须保证userId1 > userId2
	UserId1     mysql.ID
	UserId2     mysql.ID
	Score       mysql.Num
	DayScore    mysql.Num
	PeriodDay   mysql.Str
	WeekScore   mysql.Num
	PeriodWeek  mysql.Str
	MonthScore  mysql.Num
	PeriodMonth mysql.Str
	Status      StatusCp
	//中断时长
	DisconnectSecond int64
}

func (OldCp) TableName() string {
	return "cp"
}

// 获取旧的绑定中的cp
func GetOldConnectCp(model *domain.Model, tmpUserId1 mysql.ID, tmpUserId2 mysql.ID) (*OldCp, error) {
	userId1 := tmpUserId1
	userId2 := tmpUserId2
	if tmpUserId1 < tmpUserId2 {
		userId1 = tmpUserId2
		userId2 = tmpUserId1
	}
	cp := OldCp{}
	if err := model.Db.Where(&OldCp{
		UserId1: userId1,
		UserId2: userId2,
		Status:  Connect,
	}).First(&cp).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return &cp, nil
}
