package groupPower_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/_const/enum/groupPower_e"
	"hilo-user/domain/model/group_m"
	"hilo-user/myerr"
)

type GroupPowerUser struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	GroupPowerId  mysql.ID
	UserId        mysql.ID
	Role          groupPower_e.GroupPowerUserRole
}

type GroupPower struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	GroupUid      mysql.Str
	Name          mysql.Str
	Status        groupPower_e.GroupPowerStatus
}

// 查询用户加入的国家势力ID及名称（势力绑定的群组的名称）
func GetUserGroupPower(model *domain.Model, userId uint64) (uint64, string, error) {
	gpu, err := GetGroupPowerUserOrNil(model, userId)
	if err != nil {
		return 0, "", err
	}
	if gpu == nil || gpu.GroupPowerId == 0 {
		return 0, "", nil
	}
	gp, err := GetGroupPowerOrErr(model, gpu.GroupPowerId)
	if err != nil {
		return 0, "", err
	}

	powerName := ""
	if gp != nil && len(gp.GroupUid) > 0 {
		gi, err := group_m.GetGroupInfo(model, gp.GroupUid)
		if err != nil {
			return 0, "", err
		}
		if gi != nil {
			// 只要前15个字
			s := []rune(gi.Name)
			if len(s) <= 15 {
				powerName = string(s)
			} else {
				powerName = string(s[0:15])
			}
		}
	}
	return gpu.GroupPowerId, powerName, nil
}

//获取用户所在的国家势力信息，不存在则为nil
func GetGroupPowerUserOrNil(model *domain.Model, userId mysql.ID) (*GroupPowerUser, error) {
	groupPowerUser := GroupPowerUser{}
	if err := model.Db.Where(&GroupPowerUser{
		UserId: userId,
	}).First(&groupPowerUser).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	groupPowerUser.Model = model
	return &groupPowerUser, nil
}

func GetGroupPowerOrErr(model *domain.Model, id uint64) (*GroupPower, error) {
	groupPower := GroupPower{}
	if err := model.Db.Model(&GroupPower{}).First(&groupPower, id).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	groupPower.Model = model
	return &groupPower, nil
}
