package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/resource/redisCli"
	"hilo-user/_const/redis_key/group_k"
	"hilo-user/myerr"
	"strconv"
	"strings"
	"time"
)

const expireMinute = 60 * 60 * 12

//获取在房间的用户 返回值：map,key:userId, value:groupUuid
func RoomLivingUserIdFilter(model *domain.Model, userIds []mysql.ID) (map[mysql.ID]string, error) {
	userIdSet := map[mysql.ID]struct{}{}
	for i, _ := range userIds {
		userIdSet[userIds[i]] = struct{}{}
	}
	key := group_k.GetPrefixGroupRoomLiving()
	if err := ClearExpired(model, key, expireMinute); err != nil {
		return nil, myerr.WrapErr(err)
	}

	groupUserIdstrs, err := redisCli.GetRedis().ZRange(model, key, 0, -1).Result()
	if err != nil {
		return nil, myerr.WrapErr(err)
	}

	resultUserSet := map[mysql.ID]string{}
	for i, _ := range groupUserIdstrs {
		tempGroupUid, userId := analysisMemberStr(groupUserIdstrs[i])
		mylogrus.MyLog.Debugf("RoomLivingUserIdFilter, analysisMemberStr %s, %d", tempGroupUid, userId)

		if _, flag := userIdSet[userId]; flag {
			resultUserSet[userId] = tempGroupUid
		}
	}
	return resultUserSet, nil
}

func ClearExpired(model *domain.Model, key string, expireSec int64) error {
	return model.Redis.ZRemRangeByScore(model, key,
		"0", strconv.FormatInt(time.Now().Unix()-expireSec, 10)).Err()
}

func analysisMemberStr(memberStr string) (string, uint64) {
	strs := strings.Split(memberStr, "_")
	groupUid := strs[0]
	userId, err := strconv.ParseUint(strs[1], 10, 64)
	if err != nil {
		mylogrus.MyLog.Errorf("analysisMemberStr memberStr:%v err:%+v", memberStr, err)
	}
	return groupUid, userId
}
