package invite_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"time"
)

type InviteApply struct {
	Id           uint64    `json:"id"`
	UserId       uint64    `json:"user_id"`
	NewUserId    uint64    `json:"new_user_id"`
	Platform     string    `json:"platform"`
	PlatformId   string    `json:"platform_id"`
	RechargeInfo string    `json:"recharge_info"`
	Status       uint8     `json:"status"` // 状态0.未审核1.已通过2.已拒绝
	VideoUrl     string    `json:"video_url"`
	Level        string    `json:"level"`
	CreatedTime  time.Time `json:"created_time"`
	Reason       int       `json:"reason"`      // 1.已申请2.待审核3.已通过4.已拒绝"
	SubUserId    uint64    `json:"sub_user_id"` // 提交人
}

func CreateInviteApply(model *domain.Model, userId, newUserId, subUserId uint64, platform, platformId, recharge, videoUrl string) error {
	err := model.DB().Create(&InviteApply{
		UserId: userId, NewUserId: newUserId, Platform: platform, PlatformId: platformId, RechargeInfo: recharge, VideoUrl: videoUrl,
		CreatedTime: time.Now(), SubUserId: subUserId}).Error
	if err != nil {
		model.Log.Errorf("CreateInviteApply err:%v", err)
		return err
	}
	return nil
}

func GetApplyList(model *domain.Model, subUserId uint64, userIds []uint64, pageIndex, pageSize, gType int, beginTime,
	endTime time.Time) ([]*InviteApply, int64, error) {
	db := model.DB().Model(InviteApply{}).Where("user_id in (?) or sub_user_id = ?", userIds, subUserId).Where("created_time >= ? and created_time <= ?", beginTime, endTime)
	switch gType { // 1.已申请2.待审核3.已通过4.已拒绝
	case 2:
		db = db.Where("`status` = ?", 0)
	case 3:
		db = db.Where("`status` = ?", 1)
	case 4:
		db = db.Where("`status` = ?", 2)
	}
	res := make([]*InviteApply, 0)
	var count int64
	err := db.Order("id desc").Offset((pageIndex - 1) * pageSize).Find(&res).Limit(-1).Offset(-1).Count(&count).Error
	if err != nil {
		model.Log.Errorf("GetApplyList err:%v", err)
		return nil, 0, err
	}
	return res, count, nil
}

// 检查被邀请人是否存在
func IsInInviteApply(model *domain.Model, userId mysql.ID) (bool, error) {
	var apply InviteApply
	if err := model.Db.Model(InviteApply{}).Where("new_user_id = ?", userId).First(&apply).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			return false, err
		}
		return false, nil
	}
	// err == nil, record exists
	return true, nil
}

// 检查被邀请人是否存在
func GetInviteApplyNumByType(model *domain.Model, gType int, beginTime, endTime time.Time, userIds []uint64, subUserId uint64) (int, error) {
	var count int64
	db := model.Db.Model(InviteApply{}).Where("user_id in (?) or sub_user_id = ?", userIds, subUserId).Where("created_time >= ? and created_time <= ?", beginTime, endTime)
	switch gType { // 1.已申请2.待审核3.已通过4.已拒绝
	case 2:
		db = db.Where("`status` = ?", 0)
	case 3:
		db = db.Where("`status` = ?", 1)
	case 4:
		db = db.Where("`status` = ?", 2)
	}
	if err := db.Count(&count).Error; err != nil {
		return 0, err
	}
	return int(count), nil
}
