package promotion_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

// 获取推广员平台
func GetPromotionPlatforms(model *domain.Model) []string {
	return []string{"Falla", "Yalla", "Whisper", "Ahlan", "Mashi", "YoYo", "Yoho", "Echo", "Hawa", "Yalla Ludo", "Hafla",
		"Imo", "Ola Party", "ShareChat", "Viya", "Hello Yo", "Bigo Live", "Hago"}
}

// 检查是否推广员
func IsPromotionAgent(model *domain.Model, userId mysql.ID) bool {
	var promotionAgent PromotionAgent
	if err := model.Db.Model(PromotionAgent{}).Where("agent_id = ?", userId).First(&promotionAgent).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("IsPromotionAgent fail:%v", err)
		}
	} else if promotionAgent.ID > 0 {
		return true
	}
	return false
}

// 检查被邀请人是否存在
func IsPromotionInvitee(model *domain.Model, userId mysql.ID) (bool, error) {
	var promotionInvite PromotionInvite
	if err := model.Db.Model(PromotionInvite{}).Where("invitee = ?", userId).First(&promotionInvite).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			return false, err
		}
		return false, nil
	}
	// err == nil, record exists
	return true, nil
}

// 检查是否推广经理
func IsPromotionManager(model *domain.Model, userId mysql.ID) bool {
	var promotionAgent PromotionAgent
	if err := model.Db.Model(PromotionAgent{}).Where("manager_id = ?", userId).First(&promotionAgent).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("IsPromotionManager fail:%v", err)
		}
	} else if promotionAgent.ID > 0 {
		return true
	}
	return false
}

// 检查是否我的推广经理
func IsMyPromotionManager(model *domain.Model, userId, myUserId mysql.ID) bool {
	var promotionAgent PromotionAgent
	if err := model.Db.Model(PromotionAgent{}).Where("manager_id = ? and agent_id = ?", userId, myUserId).First(&promotionAgent).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("IsMyPromotionManager fail:%v", err)
		}
	} else if promotionAgent.ID > 0 {
		return true
	}
	return false
}

// 获取推广经理拥有的所有推广员，包含自己
func GetPromotionManagerAgentList(model *domain.Model, userId mysql.ID) ([]uint64, error) {
	uids := make([]uint64, 0)
	if err := model.Db.Model(PromotionAgent{}).Where("manager_id = ?", userId).Select("agent_id").
		Pluck("agent_id", &uids).Error; err != nil {
		model.Log.Errorf("IsPromotionManager fail:%v", err)
		return nil, err
	}
	return uids, nil
}

// 添加推广邀请关系
func AddPromotionInvite(model *domain.Model, managerId, agentId, invitee mysql.ID, platform, platformId, reason, inviteDate string) error {
	if err := model.Db.Create(&PromotionInvite{
		ManagerId:  managerId,
		AgentId:    agentId,
		Invitee:    invitee,
		Platform:   platform,
		PlatformId: platformId,
		Reason:     reason,
		InviteDate: inviteDate,
	}).Error; err != nil {
		return err
	}
	return addPromotionInviteLog(model, agentId, invitee, mysql.ADD)
}

// 添加推广邀请关系-日志
func addPromotionInviteLog(model *domain.Model, agentId, invitee mysql.ID, addReduce mysql.AddReduce) error {
	return model.Db.Create(&PromotionInviteLog{
		AgentId:   agentId,
		Invitee:   invitee,
		AddReduce: addReduce,
	}).Error
}
