package recommend_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/bluele/gcache"
	"time"
)

// 推荐用户送礼
type recommendUserGift struct {
	SendUserId      mysql.ID
	SendUserDiamond mysql.Num
}

var recommendUserGiftKey = "recommendUserGiftKey"
var recommendUserGiftCache = gcache.New(1).LRU().Build()

// 推荐最近送礼的50人，最近12小时赠送礼物大于100k的用户
// 先lru cache,后db
// ttl: 5min
func GetPastTop50SendGiftUsers(model *domain.Model) []recommendUserGift {
	if data, err := recommendUserGiftCache.Get(recommendUserGiftKey); err == nil {
		return data.([]recommendUserGift)
	}
	limitUserIds, _ := GetBillboardLimitUserList(model)
	var res []recommendUserGift
	if err := model.DB().Table("gift_operate g").Joins("INNER JOIN user u ON u.id = g.send_user_id").Select("send_user_id,SUM(send_user_diamond) send_user_diamond").
		Where("u.avatar <> ''").
		Where("g.created_time >= ?", time.Now().Add(-time.Hour*12)).
		Where("send_user_id NOT in ?", limitUserIds).
		Group("send_user_id").
		Having("send_user_diamond > 100000").Order("send_user_diamond DESC").Limit(34).Find(&res).Error; err != nil {
		model.Log.Errorf("GetPastTop50SendGiftUsers fail:%v", err)
	}
	recommendUserGiftCache.SetWithExpire(recommendUserGiftKey, res, time.Minute*5)
	return res
}

// 榜单黑名单
func GetBillboardLimitUserList(model *domain.Model) ([]uint64, error) {
	var userIds []uint64
	if err := model.Db.Table("billboard_limit_user").Select("user_id").Find(&userIds).Error; err != nil {
		return nil, err
	}
	return userIds, nil
}
