package res_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type ResGift struct {
	mysql.Entity
	Name              mysql.Str
	IconUrl           mysql.Str
	SvagUrl           mysql.Str
	MusicUrl          mysql.Str
	Column            uint16
	DiamondNum        mysql.Num
	BeanNum           mysql.Num
	ReceiveDiamondNum mysql.Num
	Second            mysql.Num // obsolete
	N                 mysql.Num
	GroupBroadcast    bool
	Cp                bool
	Together          bool
	Status            mysql.UserYesNo
	GiftType          mysql.Type
	HasGiftText       bool
}

// 获取所有的礼物
func FindAllResGiftsMap(model *domain.Model) (map[mysql.ID]ResGift, error) {
	res := make(map[mysql.ID]ResGift, 0)
	rows := make([]ResGift, 0)
	if err := model.DB().Model(ResGift{}).Find(&rows).Error; err != nil {
		return nil, err
	}
	for i, v := range rows {
		res[v.ID] = rows[i]
	}
	return res, nil
}

// 获取礼物
func FindResGift(model *domain.Model, giftId mysql.ID) (*ResGift, error) {
	res := new(ResGift)
	if err := model.DB().Model(ResGift{}).Where("id = ?", giftId).First(res).Error; err != nil {
		return nil, err
	}
	return res, nil
}
