package tim_m

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/sdk/tencentyun"
)

type TimHiloInfo struct {
	IsVip      bool     `json:"isVip"`
	IsPretty   bool     `json:"isPretty"`
	Medals     []uint32 `json:"medals"`
	PowerName  string   `json:"powerName"` // 用户加入的国家势力的绑定群组的名称
	NobleLevel uint16   `json:"nobleLevel"`
}

func FlushHiloInfo(extId string, isVip bool, isPrettyCode bool, medals []uint32, groupPowerName string, nobleLevel uint16) error {
	info := TimHiloInfo{IsVip: isVip, IsPretty: isPrettyCode, Medals: medals, PowerName: groupPowerName, NobleLevel: nobleLevel}
	buf, err := json.Marshal(info)
	if err != nil {
		return err
	}

	if err = tencentyun.SetUserHiloInfo(extId, string(buf)); err != nil {
		return err
	}
	return nil
}
