package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/_const/enum/user_e"
	"hilo-user/myerr"
)

//用户喜欢
type UserLike struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	LikeUserId    mysql.ID
	SceneType     user_e.UserLikeSceneType
}

type UserLikeOperate struct {
	mysql.Entity
	UserId     mysql.ID
	LikeUserId mysql.ID
	Type       user_e.UserLikeOperateType
	SceneType  user_e.UserLikeSceneType
}

func AddUserLikeOperate(model *domain.Model, userId mysql.ID, likeUserId mysql.ID, t user_e.UserLikeOperateType, sceneType user_e.UserLikeSceneType) (mysql.ID, error) {
	userLikeOperate := UserLikeOperate{
		UserId:     userId,
		LikeUserId: likeUserId,
		Type:       t,
		SceneType:  sceneType,
	}
	if err := model.Db.Create(&userLikeOperate).Error; err != nil {
		return 0, myerr.WrapErr(err)
	} else {
		return userLikeOperate.ID, nil
	}
}

func initUserLike(model *domain.Model, userId mysql.ID) *UserLike {
	return &UserLike{
		Model:  model,
		UserId: userId,
	}
}

/*func GetUserLike(model *domain.Model, userId mysql.ID, likeUserId mysql.ID) (*UserLike, error) {
	var userLike UserLike
	err := model.Db.Where(&UserLike{
		UserId:     userId,
		LikeUserId: likeUserId,
	}).First(&userLike).Error
	if err == nil {
		return &userLike, nil
	} else if err == gorm.ErrRecordNotFound {
		return nil, nil
	} else {
		return nil, myerr.WrapErr(err)
	}
}*/

//喜欢
func (userLike *UserLike) like(likeUserId mysql.ID, sceneType user_e.UserLikeSceneType) (*UserLike, mysql.ID, error) {
	err := userLike.Db.Where(&UserLike{
		UserId:     userLike.UserId,
		LikeUserId: likeUserId,
	}).First(userLike).Error
	//已经喜欢
	if err == nil {
		return nil, 0, myerr.NewWaring("已经标记喜欢")
	} else if err == gorm.ErrRecordNotFound {
		userLikeOperateId, err := AddUserLikeOperate(userLike.Model, userLike.UserId, likeUserId, user_e.LikeAdd, sceneType)
		if err != nil {
			return nil, 0, err
		}
		userLike.LikeUserId = likeUserId
		userLike.SceneType = sceneType
		return userLike, userLikeOperateId, nil
	} else {
		return nil, 0, myerr.WrapErr(err)
	}
}

//取消喜欢
func (userLike *UserLike) likeCancel(likeUserId mysql.ID) (*UserLike, error) {
	err := userLike.Db.Where(&UserLike{
		UserId:     userLike.UserId,
		LikeUserId: likeUserId,
	}).First(userLike).Error
	//
	if err == nil {
		if _, err := AddUserLikeOperate(userLike.Model, userLike.UserId, likeUserId, user_e.LikeCancel, userLike.SceneType); err != nil {
			return nil, err
		}
		userLike.SetDel()
		return userLike, nil
	} else if err == gorm.ErrRecordNotFound {
		return nil, myerr.NewWaring("没有喜欢的记录")
	} else {
		return nil, myerr.WrapErr(err)
	}
}
