package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/myerr"
)

type UserTradeUnion struct {
	mysql.Entity
	*domain.Model     `gorm:"-"`
	UserId            mysql.ID
	MatchNotification mysql.OpenClose
	AgentId           mysql.ID
	StarchatId        mysql.ID
	Avatar            string
}

func GetUserTradeUnion(userId mysql.ID) (*UserTradeUnion, error) {
	var userTradeUnion UserTradeUnion
	if err := mysql.Db.Where(UserTradeUnion{
		UserId: userId,
	}).First(&userTradeUnion).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return &userTradeUnion, nil
}

type AgentMgr struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	AgentId       mysql.ID
}

func IsAgent(userId uint64) bool {
	data := AgentMgr{}
	return mysql.Db.Where(&AgentMgr{UserId: userId}).First(&data).Error == nil
}
