package visit_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-user/myerr"
)

type UserVisit struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	VisitUserId   mysql.ID
	N             mysql.Num
}

func GetVisitInstanceOrInit(model *domain.Model, userId mysql.ID, visitUserId mysql.ID) (*UserVisit, error) {
	var userVisit UserVisit
	if err := model.Db.Where(&UserVisit{
		UserId:      userId,
		VisitUserId: visitUserId,
	}).FirstOrInit(&userVisit, UserVisit{
		UserId:      userId,
		VisitUserId: visitUserId,
		N:           0,
	}).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	userVisit.Model = model
	return &userVisit, nil
}

func (userVisit *UserVisit) UserVisitAdd() *UserVisit {
	userVisit.N = userVisit.N + 1
	return userVisit
}
