package cp_s

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"hilo-user/_const/enum/cp_e"
	"hilo-user/cv/cp_cv"
	"hilo-user/cv/user_cv"
	"hilo-user/domain/model/cp_m"
	"time"
)

type CpService struct {
	svc *domain.Service
}

func NewCpService(myContext *mycontext.MyContext) *CpService {
	svc := domain.CreateService(myContext)
	return &CpService{svc}
}

// 获取用户cp信息
func (s *CpService) GetUserCp(userId uint64, lang string) (*user_cv.CvCp, error) {
	var model = domain.CreateModelContext(s.svc.MyContext)
	cpLevel := cp_e.CpLevel0
	cpRelation, exists := cp_m.GetCpRelation(model, userId)
	if !exists {
		return nil, nil
	}
	var myPrivilegeList []user_cv.CvPrivilege
	level := cp_m.GetCpLevel(model, cpRelation.Id)
	if level.ExpireAt.Before(time.Now()) {
		level.ExpireAt = time.Now().AddDate(0, 1, 0)
	}
	cpLevel = level.Level
	cpUserId := cpRelation.UserId2
	if cpUserId == userId {
		cpUserId = cpRelation.UserId1
	}
	userPrivileges, err := cp_m.MGetUserSvipPrivilege(model, []uint64{userId})
	if err != nil {
		return nil, err
	}
	privilegeList := cp_cv.CopyCpLevelPrivilegeList(level.Level, "en")
	for i, v := range privilegeList {
		if v.CanSwitch {
			privilegeList[i].UserSwitch = userPrivileges[userId][v.Type]
		}
	}
	// 我的特权,有开关并且打开才返回
	for _, v := range privilegeList {
		if !v.CanSwitch {
			myPrivilegeList = append(myPrivilegeList, user_cv.CvPrivilege{Type: v.Type})
		} else if v.UserSwitch {
			myPrivilegeList = append(myPrivilegeList, user_cv.CvPrivilege{Type: v.Type})
		}
	}
	userBases, err := user_cv.GetUserBaseForCpMap([]uint64{cpUserId})
	if err != nil {
		return nil, err
	}
	// 返回值
	title := cp_cv.GetTranslate(237, lang)
	if msgId, ok := cp_e.CpLevelTitle[level.Level]; ok {
		title = cp_cv.GetTranslate(msgId, lang)
	}
	var oldScore uint32
	if oldCp, _ := cp_m.GetOldConnectCp(model, cpRelation.UserId1, cpRelation.UserId2); oldCp != nil {
		oldScore = uint32(oldCp.Score)
	}
	response := &user_cv.CvCp{
		CpUserInfo: userBases[cpUserId],
		CpLevel: user_cv.CvCpLevel{
			Level:  cpLevel,
			Points: oldScore + cp_m.SumCpPoints(model, cpRelation.Id), // 历史分数
			Title:  title,
		},
		MyPrivilegeList: myPrivilegeList,
		CpDays:          int(time.Now().Sub(cpRelation.CreatedTime).Hours()/24) + 1,
		CreatedUnix:     cpRelation.CreatedTime.Unix(),
	}
	return response, nil
}
