CREATE TABLE `invite_apply` (
                             `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                             `user_id` bigint NOT NULL COMMENT '发起申请者',
                             `new_user_id` bigint NOT NULL COMMENT '被邀请的人',
                             `platform` varchar(20) NOT NULL COMMENT '来自平台',
                             `platform_id` varchar(150) NOT NULL COMMENT '平台id',
                             `recharge_info` varchar(50) NOT NULL COMMENT '新用户在其它平台充值的标志',
                             `status` tinyint unsigned NOT NULL COMMENT '状态0.未审核1.已通过2.已拒绝',
                             `level` varchar(5) NOT NULL DEFAULT '' COMMENT '申请等级(S,A,B,C)',
                             `video_url` varchar(400) NOT NULL COMMENT '上传的视频url',
                             `reason` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '拒绝原因',
                             `sub_user_id` bigint NOT NULL COMMENT '提交人',
                             `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                             `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                             PRIMARY KEY (`id`),
                             KEY `user_id` (`user_id`) USING BTREE,
                             KEY `new_user_id` (`new_user_id`) USING BTREE,
                             KEY `platform` (`platform`) USING BTREE,
                             KEY `platform_id` (`platform_id`) USING BTREE,
                             KEY `status` (`status`) USING BTREE,
                             KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='新人邀请申请';

INSERT INTO hilo.res_msg_translate (`language`, title, content, icon_url, msg_type, `type`, action_type, action_url)
VALUES ('en', '', 'The welcome party application of user {nick} (ID: {diamondIncome}) has been approved, the welcome party level is: {dayNum} level, inviter {beanNum} (ID: {groupCode})', '', 1, 59, 0, ''),
       ('tr', '', '{nick} kullanıcısının (ID: {diamondIncome}) karşılama partisi uygulaması onaylandı, karşılama partisi seviyesi: {dayNum} seviyesi, davet eden {beanNum} (ID: {groupCode})', '', 1, 59, 0, ''),
       ('en', '', 'The welcome party application of user {nick} (ID: {diamondIncome}) has been rejected. The reason for the rejection is: {dayNum}, inviter {beanNum} (ID: {groupCode})', '', 1, 60, 0, ''),
       ('tr', '', '{nick} kullanıcısının (ID: {diamondIncome}) karşılama partisi başvurusu reddedildi. Reddedilme nedeni: {dayNum}, davet eden {beanNum} (ID: {groupCode})', '', 1, 60, 0, ''),
       ('en', '', 'Welcome party application, please click to enter', 'https://image.whoisamy.shop/hilo/manager/welcomeparty.png', 1, 61, 1, 'https://h5.whoisamy.shop/action/hiloHtml/2023Activity/2023_7_03WelcomeParty/index.html'),
       ('tr', '', 'hoşgeldin partisi uygulaması, girmek için lütfen tıklayınız', 'https://image.whoisamy.shop/hilo/manager/welcomeparty.png', 1, 61, 1, 'https://h5.whoisamy.shop/action/hiloHtml/2023Activity/2023_7_03WelcomeParty/index.html');


INSERT INTO mgr_permission_config (id, parent_id, name, method_url, `type`)
VALUES(3224, 2663, '欢迎派对审核', 'POST:/v1/mgr/invite/apply?$', 0),
      (3225, 2663, '欢迎派对审核-列表', 'GET:/v1/mgr/invite/apply?$', 0);
