package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

/**
 * 用户活跃分数
 **/
type MatchActityUserScore struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Score         mysql.Num
	Grade         mysql.Num
}

// 获取活跃等级
func MGetActiveGrade(model *domain.Model, userIds []mysql.ID) (map[mysql.ID]mysql.Num, error) {
	res := make(map[mysql.ID]mysql.Num)
	var rows []MatchActityUserScore
	if err := mysql.Db.Model(&MatchActityUserScore{}).Where("user_id in ?", userIds).Find(&rows).Error; err != nil {
		model.Log.Errorf("MGetActiveGrade fail:%v", err)
		return res, err
	}
	for _, r := range rows {
		res[r.UserId] = r.Grade
	}
	return res, nil
}
