package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

/**
 * 用户魅力分数
 **/
type MatchCharmUserScore struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Score         mysql.Num
	Grade         mysql.Num
}

// 批量获取魅力等级
func MGetCharmGrade(model *domain.Model, userIds []mysql.ID) (map[mysql.ID]mysql.Num, error) {
	res := make(map[mysql.ID]mysql.Num)
	var charmUserScore []*MatchCharmUserScore
	if err := model.Db.Model(&MatchCharmUserScore{}).Where("user_id in ?", userIds).Find(&charmUserScore).Error; err != nil {
		return res, err
	}
	for _, r := range charmUserScore {
		res[r.UserId] = r.Grade
	}
	return res, nil
}
