package cp_cv

import (
	"hilo-user/_const/enum/cp_e"
	"hilo-user/cv/user_cv"
)

type CvCpRank struct {
	CpId    uint64              `json:"cpId"`            // cpId
	User1   *user_cv.CvUserBase `json:"user1"`           // user1
	User2   *user_cv.CvUserBase `json:"user2,omitempty"` // user2
	Score   uint32              `json:"score"`           // 分值
	CpLevel CvCpLevel           `json:"cpLevel"`         // cp等级
	Ranking string              `json:"ranking"`         // 排名
}

type CvCpAchievement struct {
	CpId     uint64             `json:"cpId"`     // cpId
	User1    *user_cv.UserTiny  `json:"user1"`    // user1
	User2    *user_cv.UserTiny  `json:"user2"`    // user2
	Type     cp_e.CpAchievement `json:"type"`     // 成就类型 1:等级 2:空间访问人数 3:月榜最高 4:周榜最高 5:日榜最高
	TypeDesc string             `json:"typeDesc"` // 成就类型翻译
	Score    uint32             `json:"score"`    // 分值
	TimeUnix int64              `json:"timeUnix"` // 达成成就时间戳
}

type CpTops struct {
	Day  []CvCpRank `json:"day"`
	Week []CvCpRank `json:"week"`
}
