package user_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"github.com/robfig/cron"
	"hilo-user/domain/model/recommend_m"
)

// 定期同步礼物推荐用户
func SyncGiftRecommendUsers() {
	go recommend_m.SyncPastTop50SendGiftUsers(domain.CreateModelNil()) // 启动先同步一次

	c := cron.New()
	spec := "0 */5 * * * ?"
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		recommend_m.SyncPastTop50SendGiftUsers(model)
	})
	c.Start()
}
