package group_m

import (
	"git.hilo.cn/hilo-common/_const/common"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

type GroupRoles struct {
	mysql.Entity
	UserId    uint64
	ImGroupId string
	Role      common.GroupRoleType
}

type GroupMember struct {
	GroupId string
	UserId  uint64
}

func (gm *GroupMember) Find(db *gorm.DB) ([]GroupMember, error) {
	rows := make([]GroupMember, 0)
	if err := db.Where(gm).Order("created_time DESC").Find(&rows).Error; err != nil {
		return nil, err
	}
	return rows, nil
}

func GetGroupRoleById(model *domain.Model, imGroupId string, userId uint64) (role common.GroupRoleType, err error) {
	role = common.GROUP_VISITOR
	roles, _, err := GetRolesInGroup(model, imGroupId)
	if err != nil {
		return
	}
	for u, r := range roles {
		if u == userId {
			role = r
			return
		}
	}

	isGroupMember, err := IsGroupMember(model.Db, imGroupId, userId)
	if err != nil {
		return
	}
	if isGroupMember {
		role = common.GROUP_MEMBER
	}
	return
}

// 查询群组中所有有角色的成员，由级别高到低、创建时间由早到晚排列
func GetRolesInGroup(model *domain.Model, groupId string) (map[uint64]uint16, []uint64, error) {
	data := make([]GroupRoles, 0)
	err := model.Db.Where(&GroupRoles{ImGroupId: groupId}).Order("role DESC, created_time").Find(&data).Error
	if err != nil {
		return nil, nil, err
	}

	result := make(map[uint64]uint16, 0)
	orders := make([]uint64, 0)
	for _, i := range data {
		orders = append(orders, i.UserId)
		result[i.UserId] = i.Role
	}
	return result, orders, nil
}

func IsGroupMember(db *gorm.DB, groupId string, userId uint64) (bool, error) {
	gm := GroupMember{
		GroupId: groupId,
		UserId:  userId,
	}
	rows, err := gm.Find(db)
	if err != nil {
		return false, err
	}
	return len(rows) > 0, nil
}
