package recommend_r

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/gin-gonic/gin"
	"hilo-user/cv/user_cv"
	"hilo-user/domain/model/group_m"
	"hilo-user/domain/model/recommend_m"
	"hilo-user/domain/model/user_m"
	"hilo-user/resp"
)

type RecommendUser struct {
	User        *user_cv.UserTiny `json:"user"`
	CurrentRoom string            `json:"currentRoom"` // 当前用户所在房间（产品叫“群组”）
}

// @Tags 用户推荐
// @Summary 推荐最近送礼的50人，最近12小时赠送礼物大于100k的用户
// @Param token header string true "token"
// @Success 200 {object} []RecommendUser
// @Router /v1/recommend/user/gift [get]
func UserRecommendGift(c *gin.Context) (*mycontext.MyContext, error) {
	myContext := mycontext.CreateMyContext(c.Keys)
	model := domain.CreateModelContext(myContext)
	// 获取推荐
	recommendUser := recommend_m.GetPastTop50SendGiftUsers(model)
	var response = make([]RecommendUser, 0)
	if len(recommendUser) <= 0 {
		resp.ResponseOk(c, response)
		return myContext, nil
	}
	var userIds []mysql.ID
	for _, v := range recommendUser {
		userIds = append(userIds, v.SendUserId)
	}
	users, err := user_m.GetUserMapByIds(model, userIds)
	if err != nil {
		return myContext, err
	}
	rooms, err := group_m.RoomLivingUserIdFilter(model, userIds)
	if err != nil {
		return nil, err
	} else if len(rooms) > 0 {
		// to txGroupIds
		var imGroupIds []string
		for _, imGroupId := range rooms {
			imGroupIds = append(imGroupIds, imGroupId)
		}
		txGroupIdsMap, _ := group_m.ToTxGroupIdMap(model, imGroupIds)
		for uid, room := range rooms {
			rooms[uid] = txGroupIdsMap[room]
		}
	}
	for _, v := range recommendUser {
		response = append(response, RecommendUser{user_cv.UserToTiny(users[v.SendUserId]), rooms[v.SendUserId]})
	}
	resp.ResponseOk(c, response)
	return myContext, nil
}
