package cp_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

//注册监听
var spaceVisitListen = new(domain.EventBase)

type SpaceVisitEvent struct {
	UserId           mysql.ID
	CpId             mysql.ID
	UserId1, UserId2 mysql.ID
}

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddCpSpaceVisitSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(spaceVisitListen, callback)
}

//加入到异步操作中
func AddCpSpaceVisitAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(spaceVisitListen, callback)
}

//领域事件发布
func PublishCpSpaceVisit(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(spaceVisitListen, model, event)
}
