package cp_e

import "git.hilo.cn/hilo-common/resource/mysql"

const (
	EffectDays   = 30 // 30天有效期
	CpHeadwearId = 2571
)

type CpLevel int

const (
	CpLevel0 CpLevel = 0 // 无称号
	CpLevel1 CpLevel = 1 // 恋爱CP
	CpLevel2 CpLevel = 2 // 甜蜜CP
	CpLevel3 CpLevel = 3 // 忠诚CP
	CpLevel4 CpLevel = 4 // 炽热CP
	CpLevel5 CpLevel = 5 // 荣耀CP

	CpLevelMax = CpLevel5
)

var (
	// cp等级积分
	CpLevelPoints = map[CpLevel]mysql.Num{
		CpLevel0: 0,
		CpLevel1: 200000,
		CpLevel2: 800000,
		CpLevel3: 1000000,
		CpLevel4: 3000000,
		CpLevel5: 10000000,
	}
	// cp等级icon // todo ui
	CpLevelIcon = map[CpLevel]string{
		CpLevel0: "icon0.png",
		CpLevel1: "icon1.png",
		CpLevel2: "icon2.png",
		CpLevel3: "icon3.png",
		CpLevel4: "icon4.png",
		CpLevel5: "icon5.png",
	}
	// cp等级称号
	CpLevelTitle = map[CpLevel]uint{
		CpLevel1: 252,
		CpLevel2: 253,
		CpLevel3: 254,
		CpLevel4: 255,
		CpLevel5: 256,
	}
	// cp特权名称
	CpPrivilegeNameMsgId = map[CpPrivilege]uint{
		CpPrivilegeSpace:         234,
		CpPrivilegeBanner:        235,
		CpPrivilegeMedal:         236,
		CpPrivilegeCert:          237,
		CpPrivilegeRoomEffect:    238,
		CpPrivilegeHeadwear:      239,
		CpPrivilegeActiveProfile: 240,
		CpPrivilegeMicEffect:     241,
	}
	// cp特权描述
	CpPrivilegeDescMsgId = map[CpPrivilege]uint{
		CpPrivilegeSpace:         264,
		CpPrivilegeBanner:        265,
		CpPrivilegeMedal:         266,
		CpPrivilegeCert:          267,
		CpPrivilegeRoomEffect:    268,
		CpPrivilegeHeadwear:      269,
		CpPrivilegeActiveProfile: 270,
		CpPrivilegeMicEffect:     271,
	}
	// cp特权icon
	CpPrivilegeIcon = map[CpPrivilege]map[CpLevel]string{
		CpPrivilegeSpace:         {CpLevel0: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_space.png", CpLevel1: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_space.png", CpLevel2: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_space.png", CpLevel3: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_space.png", CpLevel4: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_space.png", CpLevel5: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_space.png"},
		CpPrivilegeBanner:        {CpLevel1: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_banner1.png", CpLevel2: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_banner2.png", CpLevel3: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_banner3.png", CpLevel4: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_banner4.png", CpLevel5: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_banner5.png"},
		CpPrivilegeMedal:         {CpLevel1: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_medal1.png", CpLevel2: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_medal2.png", CpLevel3: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_medal3.png", CpLevel4: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_medal4.png", CpLevel5: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_medal5.png"},
		CpPrivilegeCert:          {CpLevel0: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_cert0.png", CpLevel1: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_cert1.png", CpLevel2: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_cert2.png", CpLevel3: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_cert3.png", CpLevel4: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_cert4.png", CpLevel5: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_cert5.png"},
		CpPrivilegeRoomEffect:    {CpLevel2: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_enter2.png", CpLevel3: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_enter3.png", CpLevel4: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_enter4.png", CpLevel5: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_enter5.png"},
		CpPrivilegeHeadwear:      {CpLevel3: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_headwear.png", CpLevel4: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_headwear.png", CpLevel5: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_headwear.png"},
		CpPrivilegeActiveProfile: {CpLevel4: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_profile.png", CpLevel5: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_profile.png"},
		CpPrivilegeMicEffect:     {CpLevel5: "https://image.whoisamy.shop/hilo/resource/cp/cp_p_mic.png"},
	}
)

type CpPrivilege int

const (
	CpPrivilegeSpace         CpPrivilege = 1 // 空间
	CpPrivilegeBanner        CpPrivilege = 2 // 横幅
	CpPrivilegeMedal         CpPrivilege = 3 // 等级勋章
	CpPrivilegeCert          CpPrivilege = 4 // 证书
	CpPrivilegeRoomEffect    CpPrivilege = 5 // 进场特效
	CpPrivilegeHeadwear      CpPrivilege = 6 // 头像头饰
	CpPrivilegeActiveProfile CpPrivilege = 7 // 动态资料卡
	CpPrivilegeMicEffect     CpPrivilege = 8 // 麦位特效
)
