package test

import (
	"git.hilo.cn/hilo-common/_const/enum/timezone_e"
	"git.hilo.cn/hilo-common/domain"
	"hilo-user/domain/model/cp_m"
	"testing"
	"time"
)

func TestInitCpAnniversary(t *testing.T) {
	err := cp_m.InitCpAnniversary(domain.CreateModelNil(), cp_m.CpRelation{
		Id:      1,
		UserId1: 7642,
		UserId2: 4549,
	}, "ar")
	println(err)
}

func TestCalcNextAnniversary(t *testing.T) {
	t2 := cp_m.CalcNextAnniversary(1686211996, time.Local)
	println(t2)
}

func TestCalLoc(t *testing.T) {
	loc := timezone_e.GetFixedTimezone("GMT+8")
	println(time.Now().In(loc).Format("2006-01-02 15:04:05"))
	loc = timezone_e.GetFixedTimezone("GMT+3")
	println(time.Now().In(loc).Format("2006-01-02 15:04:05"))
	loc = timezone_e.GetFixedTimezone("GMT+5")
	println(time.Now().In(loc).Format("2006-01-02 15:04:05"))
}

func TestSumCpScore(t *testing.T) {
	model := domain.CreateModelNil()
	old, err := cp_m.GetOldConnectCp(model, 7642, 4549)
	t.Logf("%v-%v", old, err)
	n := cp_m.SumCpPoints(model, 1)
	t.Logf("%v", n)
}
