CREATE TABLE `cp_relation` (
                                      `id` bigint unsigned AUTO_INCREMENT NOT NULL,
                                      `user_id1` bigint NOT NULL COMMENT 'user_id1',
                                      `user_id2` bigint NOT NULL COMMENT 'user_id2',
                                      `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                      `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                      PRIMARY KEY (`id`),
                                      UNIQUE KEY `uid1_idx` (`user_id1`) USING BTREE,
                                      UNIQUE KEY `uid2_idx` (`user_id2`) USING BTREE,
                                      KEY `ctime_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='cp关系表';

INSERT INTO hilo.diamond_operate_set (diamond_num, frequency_num, frequency_day, diamond_max_num, add_reduce, `type`, name, status, diamond_type)
VALUES (-1, -1, -1, -1, 2, 94, 'cp邀请扣费', 1, 1),
       (-1, -1, -1, -1, 1, 95, 'cp邀请退费', 1, 1);

CREATE TABLE `cp_invite` (
                             `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                             `user_id` bigint NOT NULL COMMENT '发起邀请者',
                             `invite_user_id` bigint NOT NULL COMMENT '被邀请的人',
                             `diamond_num` int unsigned NOT NULL COMMENT '邀请者花费的钻石',
                             `status` tinyint unsigned NOT NULL COMMENT '状态1.未接受2.已接受3.拒接导致退费4.过期导致退费',
                             `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                             `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                             PRIMARY KEY (`id`),
                             KEY `uid_idx` (`user_id`) USING BTREE,
                             KEY `uid2_idx` (`invite_user_id`) USING BTREE,
                             KEY `status_idx` (`status`) USING BTREE,
                             KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='cp邀请发起记录';

CREATE TABLE `cp_cancel` (
                             `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                             `user_id` bigint NOT NULL COMMENT '发起者',
                             `rec_user_id` bigint NOT NULL COMMENT '接收者',
                             `status` tinyint unsigned NOT NULL COMMENT '状态1.未处理2.发起者已撤销3.对方已确认4.到期自动确认',
                             `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                             `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                             PRIMARY KEY (`id`),
                             KEY `uid_idx` (`user_id`) USING BTREE,
                             KEY `uid2_idx` (`rec_user_id`) USING BTREE,
                             KEY `status_idx` (`status`) USING BTREE,
                             KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='cp解除发起记录';


INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (242, 'zh', '仅限送给CP'),
       (242, 'en', 'Only for CP'),
       (242, 'ar', 'فقط من أجل CP'),
       (242, 'tr', 'Sadece CP için'),
       (242, 'id', 'Hanya untuk CP'),
       (242, 'ru', 'Только для КП'),
       (242, 'ko', 'CP 전용'),
       (242, 'pt', 'Somente para CP'),
       (242, 'th', 'สำหรับซีพีเท่านั้น'),
       (242, 'ca', 'Solo para CP'),
       (242, 'hi', 'केवल सीपी के लिए'),
       (242, 'vi', 'Chỉ dành cho CP'),
       (242, 'ur', 'صرف CP کے لیے');

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (243, 'zh', '对方已有CP了'),
       (243, 'en', 'The opponent already has CP'),
       (243, 'ar', 'الطرف الآخر لديه بالفعل CP'),
       (243, 'tr', "Rakibin zaten CP'si var"),
       (243, 'id', 'Lawan sudah memiliki CP'),
       (243, 'ru', 'У противника уже есть CP'),
       (243, 'ko', '상대는 이미 CP를 가지고 있습니다.'),
       (243, 'pt', 'O oponente já tem CP'),
       (243, 'th', 'ฝ่ายตรงข้ามมี CP อยู่แล้ว'),
       (243, 'ca', 'El oponente ya tiene CP'),
       (243, 'hi', 'विरोधी के पास पहले से ही CP है'),
       (243, 'vi', 'Đối thủ đã có CP'),
       (243, 'ur', 'مخالف کے پاس پہلے ہی سی پی ہے۔');

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (244, 'zh', "你想要和我成为CP吗？"),
       (244, 'en', "Do you want to be CP with me？"),
       (244, 'ar', "هل ترغب في ان تكون CP الخاص معي؟"),
       (244, 'tr', "Benimle CP olmak ister misin?"),
       (244, 'id', "Apakah Anda ingin menjadi CP dengan saya？"),
       (244, 'ru', "Хочешь быть со мной?"),
       (244, 'ko', "나랑 CP할래?"),
       (244, 'pt', "Você quer ser CP comigo?"),
       (244, 'th', "อยากเป็น CP กับฉันไหม?"),
       (244, 'ca', "¿Quieres ser CP conmigo?"),
       (244, 'hi', "क्या आप मेरे साथ सीपी बनना चाहते हैं?"),
       (244, 'vi', "Bạn có muốn trở thành CP với tôi không?"),
       (244, 'ur', "کیا آپ میرے ساتھ CP بننا چاہتے ہیں؟");


INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (245, 'zh', "我想成为你的CP"),
       (245, 'en', "I want to be your CP"),
       (245, 'ar', "أريد أن أكون CP الخاص بك"),
       (245, 'tr', "senin CP'n olmak istiyorum"),
       (245, 'id', "Saya ingin menjadi CP Anda"),
       (245, 'ru', "Я хочу быть твоим CP"),
       (245, 'ko', "당신의 CP가 되고 싶습니다"),
       (245, 'pt', "quero ser seu cp"),
       (245, 'th', "ฉันอยากเป็นซีพีของคุณ"),
       (245, 'ca', "quiero ser tu CP"),
       (245, 'hi', "मैं आपका सीपी बनना चाहता हूं"),
       (245, 'vi', "Tôi muốn trở thành CP của bạn"),
       (245, 'ur', "میں آپ کا CP بننا چاہتا ہوں۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (246, 'zh', "24小时后自动失效"),
       (246, 'en', "Automatically expires after 24 hours"),
       (246, 'ar', "تنتهي الصلاحية تلقائيًا بعد 24 ساعة"),
       (246, 'tr', "24 saat sonra otomatik olarak sona erer"),
       (246, 'id', "Secara otomatis kedaluwarsa setelah 24 jam"),
       (246, 'ru', "Автоматически истекает через 24 часа"),
       (246, 'ko', "24시간 후 자동 만료"),
       (246, 'pt', "Expira automaticamente após 24 horas"),
       (246, 'th', "หมดอายุโดยอัตโนมัติหลังจาก 24 ชั่วโมง"),
       (246, 'ca', "Caduca automáticamente después de 24 horas"),
       (246, 'hi', "24 घंटे के बाद स्वतः समाप्त हो जाता है"),
       (246, 'vi', "Tự động hết hạn sau 24 giờ"),
       (246, 'ur', "24 گھنٹے کے بعد خود بخود ختم ہو جاتا ہے۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (247, 'zh', "我想解绑CP"),
       (247, 'en', "I want to unbind CP"),
       (247, 'ar', "أريد فك ارتباط CP"),
       (247, 'tr', "CP bağlantısını kaldırmak istiyorum"),
       (247, 'id', "Saya ingin melepaskan CP"),
       (247, 'ru', "Я хочу отвязать CP"),
       (247, 'ko', "CP 바인딩을 해제하고 싶습니다."),
       (247, 'pt', "quero desvincular o CP"),
       (247, 'th', "ฉันต้องการยกเลิกการเชื่อมโยง CP"),
       (247, 'ca', "Quiero desvincular CP"),
       (247, 'hi', "मैं सीपी को खोलना चाहता हूं"),
       (247, 'vi', "Tôi muốn hủy liên kết CP"),
       (247, 'ur', "میں CP کو بند کرنا چاہتا ہوں۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (248, 'zh', "我们已经是CP了！"),
       (248, 'en', "We are already CP!"),
       (248, 'ar', "أصبحنا CP!"),
       (248, 'tr', "Biz zaten CP'yiz!"),
       (248, 'id', "Kami sudah CP!"),
       (248, 'ru', "Мы уже КП!"),
       (248, 'ko', "우리는 이미 CP입니다!"),
       (248, 'pt', "Já somos CP!"),
       (248, 'th', "เราเป็นซีพีแล้ว!"),
       (248, 'ca', "¡Ya somos CP!"),
       (248, 'hi', "हम पहले से ही सीपी हैं!"),
       (248, 'vi', "Chúng ta đã là CP rồi!"),
       (248, 'ur', "ہم پہلے ہی CP ہیں!");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (249, 'zh', "庆祝礼物已发送到%s的背包"),
       (249, 'en', "Celebration gifts have been sent to %s 's backpack"),
       (249, 'ar', "تم إرسال هدايا الاحتفال إلى حقيبة %s"),
       (249, 'tr', "%s'nin sırt çantasına kutlama hediyeleri gönderildi"),
       (249, 'id', "Hadiah perayaan telah dikirim ke ransel %s"),
       (249, 'ru', "Праздничные подарки отправлены в рюкзак %s."),
       (249, 'ko', "축하 선물이 %s의 배낭으로 보내졌습니다."),
       (249, 'pt', "Presentes de comemoração foram enviados para a mochila de %s"),
       (249, 'th', "ของขวัญฉลองถูกส่งไปที่กระเป๋าเป้สะพายหลังของ %s แล้ว"),
       (249, 'ca', "Se han enviado regalos de celebración a la mochila de %s"),
       (249, 'hi', "उत्सव उपहार %s के बैकपैक में भेज दिए गए हैं"),
       (249, 'vi', "Quà kỷ niệm đã được gửi tới ba lô của %s'"),
       (249, 'ur', "جشن کے تحائف %s کے بیگ میں بھیجے گئے ہیں۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (250, 'zh', "%s已拒绝CP邀请"),
       (250, 'en', "%s has rejected the CP invitation"),
       (250, 'ar', "%s رفض دعوة CP"),
       (250, 'tr', "%s CP davetini reddetti"),
       (250, 'id', "%s telah menolak undangan CP"),
       (250, 'ru', "%s отклонил приглашение CP"),
       (250, 'ko', "%s님이 CP 초대를 거부했습니다."),
       (250, 'pt', "%s rejeitou o convite CP"),
       (250, 'th', "%s ได้ปฏิเสธคำเชิญ CP"),
       (250, 'ca', "%s ha rechazado la invitación de CP"),
       (250, 'hi', "%s ने CP आमंत्रण को अस्वीकार कर दिया है"),
       (250, 'vi', "%s đã từ chối lời mời CP"),
       (250, 'ur', "%s نے CP دعوت نامے کو مسترد کر دیا ہے۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (251, 'zh', "已解绑CP，CP值被清空，CP特权已消失"),
       (251, 'en', "The CP has been unbound, the CP points has been cleared, and the CP privilege has disappeared"),
       (251, 'ar', "تم فك ارتباط CP ، وتم مسح نقاط CP ، واختفيت امتيازات CP"),
       (251, 'tr', "CP bağlantısı kaldırıldı, CP puanları silindi ve CP ayrıcalığı kayboldu"),
       (251, 'id', "CP telah dilepas, poin CP telah dihapus, dan hak istimewa CP telah hilang"),
       (251, 'ru', "CP был развязан, CP-очки были очищены, а привилегия CP исчезла."),
       (251, 'ko', "CP가 해제되고 CP 포인트가 해제되며 CP 특권이 사라졌습니다."),
       (251, 'pt', "O CP foi desvinculado, os pontos do CP foram apagados e o privilégio do CP desapareceu"),
       (251, 'th', "CP ไม่ถูกผูกมัด คะแนน CP ถูกล้าง และสิทธิ์ CP หายไป"),
       (251, 'ca', "El CP se ha desvinculado, los puntos de CP se han borrado y el privilegio de CP ha desaparecido"),
       (251, 'hi', "सीपी अनबाउंड हो गया है, सीपी पॉइंट क्लियर हो गए हैं, और सीपी विशेषाधिकार गायब हो गया है"),
       (251, 'vi', "CP đã bị hủy liên kết, điểm CP đã bị xóa và đặc quyền CP đã biến mất"),
       (251, 'ur', "CP کو غیر پابند کر دیا گیا ہے، CP پوائنٹس کو صاف کر دیا گیا ہے، اور CP کا استحقاق غائب ہو گیا ہے");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (258, 'zh', "已经过期"),
       (258, 'en', "Already expired"),
       (258, 'ar', "تم انتهاء صلاحيتها"),
       (258, 'tr', "Zaten süresi dolmuş"),
       (258, 'id', "Sudah kedaluwarsa"),
       (258, 'ru', "Срок действия уже истек"),
       (258, 'ko', "이미 만료됨"),
       (258, 'pt', "Já expirou"),
       (258, 'th', "หมดอายุแล้ว"),
       (258, 'ca', "ya vencido"),
       (258, 'hi', "पहले ही समाप्त हो चुका है"),
       (258, 'vi', "Đã hết hạn"),
       (258, 'ur', "پہلے ہی ختم ہو چکا ہے۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (272, 'zh', "绑定CP花费"),
       (272, 'en', "Binding CP cost"),
       (272, 'ar', "تكلفة CP الارتباط"),
       (272, 'tr', "Bağlayıcı CP maliyeti"),
       (272, 'id', "Mengikat biaya CP"),
       (272, 'ru', "Привязка стоимости CP"),
       (272, 'ko', "구속력 있는 CP 비용"),
       (272, 'pt', "Custo de CP vinculativo"),
       (272, 'th', "ค่าซีพีเข้าเล่ม"),
       (272, 'ca', "Costo de CP vinculante"),
       (272, 'hi', "बाध्यकारी सीपी लागत"),
       (272, 'vi', "Chi phí CP ràng buộc"),
       (272, 'ur', "بائنڈنگ CP لاگت");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (273, 'zh', "绑定CP返还"),
       (273, 'en', "Binding CP return"),
       (273, 'ar', "استرداد CP الارتباط"),
       (273, 'tr', "Bağlayıcı CP dönüşü"),
       (273, 'id', "Pengembalian CP yang mengikat"),
       (273, 'ru', "Обязательный возврат CP"),
       (273, 'ko', "바인딩 CP 반환"),
       (273, 'pt', "Retorno de CP vinculativo"),
       (273, 'th', "การคืนค่า CP ที่มีผลผูกพัน"),
       (273, 'ca', "Retorno de CP vinculante"),
       (273, 'hi', "बाध्यकारी सीपी वापसी"),
       (273, 'vi', "Lợi nhuận CP ràng buộc"),
       (273, 'ur', "بائنڈنگ CP واپسی۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (274, 'zh', "%s撤销了解绑CP的申请"),
       (274, 'en', "%s canceled the application to unbind CP"),
       (274, 'ar', "%s قام بسحب طلبه لفك ارتباط CP"),
       (274, 'tr', "%s, CP'nin bağlantısını kaldırma başvurusunu iptal etti"),
       (274, 'id', "%s membatalkan aplikasi untuk melepaskan CP"),
       (274, 'ru', "%s отменил заявку на отвязку CP"),
       (274, 'ko', "%s이(가) CP 바인딩 해제 신청을 취소했습니다."),
       (274, 'pt', "%s cancelou o aplicativo para desvincular CP"),
       (274, 'th', "%s ยกเลิกแอปพลิเคชันเพื่อยกเลิกการเชื่อมโยง CP"),
       (274, 'ca', "%s canceló la solicitud para desvincular CP"),
       (274, 'hi', "%s ने सीपी को अनबाइंड करने के लिए आवेदन को रद्द कर दिया"),
       (274, 'vi', "%s đã hủy đơn đăng ký hủy liên kết CP"),
       (274, 'ur', "%s نے CP کی پابندی ختم کرنے کے لیے درخواست منسوخ کر دی۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (275, 'zh', "等待对方接受"),
       (275, 'en', "Waiting to be accepted"),
       (275, 'ar', "في انتظار قبول الطرف الآخرى"),
       (275, 'tr', "Kabul edilmeyi bekliyorum"),
       (275, 'id', "Menunggu untuk diterima"),
       (275, 'ru', "Ожидание принятия"),
       (275, 'ko', "수락 대기 중"),
       (275, 'pt', "Esperando ser aceito"),
       (275, 'th', "รอรับได้เลยครับ"),
       (275, 'ca', "Esperando ser aceptado"),
       (275, 'hi', "स्वीकार किए जाने की प्रतीक्षा कर रहा है"),
       (275, 'vi', "Chờ đợi để được chấp nhận"),
       (275, 'ur', "قبول ہونے کا انتظار ہے۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (276, 'zh', "邀请被接受"),
       (276, 'en', "Invitation accepted"),
       (276, 'ar', "تم قبول الدعوة"),
       (276, 'tr', "davet kabul edildi"),
       (276, 'id', "undangan diterima"),
       (276, 'ru', "приглашение принято"),
       (276, 'ko', "초대 수락됨"),
       (276, 'pt', "convite aceito"),
       (276, 'th', "ยอมรับคำเชิญแล้ว"),
       (276, 'ca', "invitación aceptada"),
       (276, 'hi', "निमंत्रण स्वीकार किया"),
       (276, 'vi', "lời mời được chấp nhận"),
       (276, 'ur', "دعوت قبول کی");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (277, 'zh', "邀请被拒绝"),
       (277, 'en', "Invitation refused"),
       (277, 'ar', "تم رفض الدعوة"),
       (277, 'tr', "davet reddedildi"),
       (277, 'id', "undangan ditolak"),
       (277, 'ru', "приглашение отклонено"),
       (277, 'ko', "초대가 거부됨"),
       (277, 'pt', "convite recusado"),
       (277, 'th', "คำเชิญถูกปฏิเสธ"),
       (277, 'ca', "invitación rechazada"),
       (277, 'hi', "निमंत्रण अस्वीकार कर दिया"),
       (277, 'vi', "lời mời từ chối"),
       (277, 'ur', "دعوت سے انکار کر دیا");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (278, 'zh', "已解绑CP"),
       (278, 'en', "CP has been unbound"),
       (278, 'ar', "تم فك علاقة CP"),
       (278, 'tr', "CP bağlantısı kaldırıldı"),
       (278, 'id', "CP telah dilepaskan"),
       (278, 'ru', "CP не привязан"),
       (278, 'ko', "CP가 언바운드되었습니다."),
       (278, 'pt', "CP foi desvinculado"),
       (278, 'th', "CP หลุดแล้ว"),
       (278, 'ca', "CP ha sido desvinculado"),
       (278, 'hi', "सीपी अनबाउंड किया गया है"),
       (278, 'vi', "CP không bị ràng buộc"),
       (278, 'ur', "سی پی کو غیر پابند کیا گیا ہے۔");

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (279, 'zh', "已被取消"),
       (279, 'en', "Has been canceled"),
       (279, 'ar', "تم الإلغاء"),
       (279, 'tr', "İptal edildi"),
       (279, 'id', "Telah dibatalkan"),
       (279, 'ru', "Была отменена"),
       (279, 'ko', "취소되었습니다"),
       (279, 'pt', "Foi cancelado"),
       (279, 'th', "ถูกยกเลิก"),
       (279, 'ca', "Ha sido cancelado"),
       (279, 'hi', "रद्द किया गया"),
       (279, 'vi', "Đã hủy bỏ"),
       (279, 'ur', "منسوخ کر دیا گیا ہے۔");

عيد ميلاد%s