package route

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"github.com/gin-gonic/gin"
	ginSwagger "github.com/swaggo/gin-swagger"
	"github.com/swaggo/gin-swagger/swaggerFiles"
	"hilo-user/_const/enum/msg_e"
	_ "hilo-user/docs"
	"hilo-user/domain/model/msg_m"
	"hilo-user/resp"
	"hilo-user/route/cp_r"
	"hilo-user/route/user_r"
)

func InitRouter() *gin.Engine {
	var r = gin.Default()

	r.GET("/user-swagger/*any", ginSwagger.WrapHandler(swaggerFiles.Handler))

	needLogin := r.Group("")
	needLogin.Use(ExceptionHandle, LoggerHandle, JWTApiHandle)
	v1 := needLogin.Group("/v1")
	v2 := needLogin.Group("/v2")
	user := v1.Group("/user")
	{
		user.GET("/nameplate", wrapper(user_r.UserNameplate))
		user.GET("/bag/:resType", wrapper(user_r.UserBag))
	}
	cp := v2.Group("/cp")
	{
		cp.GET("/space", wrapper(cp_r.CpSpace))
		cp.PUT("/privilege/openClose", wrapper(cp_r.CpPrivilegeOpenClose))
		cp.GET("/rank/:queryType", wrapper(cp_r.CpRank))
		cp.GET("/my/:queryType", wrapper(cp_r.CpMy))
		cp.GET("/achievement", wrapper(cp_r.CpAchievement))
		cp.GET("/top3", wrapper(cp_r.CpTop3))

		cp.POST("/anniversary", wrapper(cp_r.PostAnniversary))
		cp.PUT("/anniversary/:id", wrapper(cp_r.PutAnniversary))
		cp.GET("/anniversary", wrapper(cp_r.PageAnniversary))
		cp.DELETE("/anniversary/:id", wrapper(cp_r.DelAnniversary))

		cp.GET("/relation/check", wrapper(cp_r.CheckUserCpRelation))
		cp.POST("/relation", wrapper(cp_r.CpRelation))
		cp.POST("/relation/invite/reply", wrapper(cp_r.ReplyCpInvite))
		cp.POST("/relation/cancel/reply", wrapper(cp_r.ReplyCpCancel))
		//cp.GET("/relation/detail", wrapper(cp_r.CpDetailPage))
		cp.GET("/im/check", wrapper(cp_r.CheckCpImExpire))
	}
	inner := r.Group("/inner")
	inner.Use(ExceptionHandle, LoggerHandle)
	innerUser := inner.Group("/user")
	{
		innerUser.GET("/levels", wrapper(user_r.MGetUserLevels))
		innerUser.GET("/bag/id", wrapper(user_r.GetUserBagId))
		innerUser.GET("/cp", wrapper(user_r.GetUserCp))
		innerUser.GET("/cpRelations", wrapper(user_r.MGetUserCpRelation))
		innerUser.GET("/cp/pair", wrapper(user_r.GetUserCpPair))
	}
	// 道具相关
	innerProp := inner.Group("/prop")
	{
		innerProp.POST("/bag/send", wrapper(user_r.SendUserBag))           // 下发背包道具,暂礼物
		innerProp.POST("/noble/send", wrapper(user_r.SendUserNoble))       // 下发贵族
		innerProp.POST("/headwear/send", wrapper(user_r.SendUserHeadwear)) // 下发头饰
		innerProp.POST("/ride/send", wrapper(user_r.SendUserRide))         // 下发座驾
	}
	r.GET("/test", wrapper(Test))
	return r
}

func Test(c *gin.Context) (*mycontext.MyContext, error) {
	var model = domain.CreateModelContext(nil)
	myCtx := mycontext.CreateMyContext(c.Keys)
	// 下发hilo小助手通知
	if err := msg_m.NewUserRecord(model, 4549, msg_e.AddProps, "", 0, "", fmt.Sprintf("%d", 10), "https://image.whoisamy.shop/hilo/manager/1b95e0e63b814261acccc6e1f1736627.png", "", "").Persistent(); err != nil {
		model.Log.Errorf("NewUserRecord fail")
	} else {
		msg_m.SendEmasMsgAssistant(model, "f98c7fe5698e447c998615332eb660d1", "iOS")
	}
	resp.ResponseOk(c, struct{}{})
	return myCtx, nil
}
