package res_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/_const/enum/res_e"
	"hilo-user/myerr"
	"hilo-user/myerr/bizerr"
)

type ResProperty struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	Name          mysql.Str
	PicUrl        mysql.Str
	EffectUrl     mysql.Str
}

type ResPropertyDiamond struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	ResPropertyId mysql.ID
	DiamondNum    mysql.Num
	Second        mysql.Num
	Status        mysql.UserYesNo
}

type ResPropertyAvatar struct {
	mysql.Entity
	*domain.Model  `gorm:"-"`
	ResPropertyId  mysql.ID
	Type           res_e.ResPropertyAvatarType
	SendUserId     mysql.ID
	ReceiverUserId mysql.ID
}

func InitResPropertyDiamond(model *domain.Model, resPropertyId mysql.ID, diamondNum mysql.Num, second mysql.Num) *ResPropertyDiamond {
	return &ResPropertyDiamond{
		Model:         model,
		ResPropertyId: resPropertyId,
		DiamondNum:    diamondNum,
		Second:        second,
		Status:        mysql.NOUSER,
	}
}

//id获取头饰，不存在则抛异常
func GetPropertyById(model *domain.Model, id mysql.ID) (*ResProperty, error) {
	resProperty := ResProperty{}
	if err := model.Db.Model(&ResProperty{}).First(&resProperty, id).Error; err != nil {
		return nil, myerr.WrapErr(err)
	} else {
		resProperty.Model = model
		return &resProperty, nil
	}
}

func GetResPropertyDiamond(model *domain.Model, resPropertyDiamondId mysql.ID) (*ResPropertyDiamond, error) {
	resPropertyDiamond := ResPropertyDiamond{}
	if err := model.Db.Model(&ResPropertyDiamond{}).First(&resPropertyDiamond, resPropertyDiamondId).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	if resPropertyDiamond.Status == mysql.NOUSER {
		return nil, bizerr.ResPropertyDiamondNoUse
	}
	return &resPropertyDiamond, nil
}

func GetResPropertyDiamondByPropertyIdOrNil(model *domain.Model, resPropertyId mysql.ID) (*ResPropertyDiamond, error) {
	resPropertyDiamond := ResPropertyDiamond{}
	if err := model.Db.Model(&ResPropertyDiamond{}).Where(&ResPropertyDiamond{
		ResPropertyId: resPropertyId,
	}).First(&resPropertyDiamond).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	resPropertyDiamond.Model = model
	return &resPropertyDiamond, nil
}

//设置成未使用
func (resPropertyDiamond *ResPropertyDiamond) SetUser() *ResPropertyDiamond {
	resPropertyDiamond.Status = mysql.USER
	return resPropertyDiamond
}

//设置成未使用
func (resPropertyDiamond *ResPropertyDiamond) SetNoUser() *ResPropertyDiamond {
	resPropertyDiamond.Status = mysql.NOUSER
	return resPropertyDiamond
}

func (resPropertyDiamond *ResPropertyDiamond) SetDiamondNum(diamondNum uint32) *ResPropertyDiamond {
	resPropertyDiamond.DiamondNum = diamondNum
	return resPropertyDiamond
}

func (resPropertyDiamond *ResPropertyDiamond) SetSecond(second uint32) *ResPropertyDiamond {
	resPropertyDiamond.Second = second
	return resPropertyDiamond
}

func AddProperty(model *domain.Model, p *ResProperty) error {
	return model.Db.Create(p).Error
}

func EditProperty(model *domain.Model, propertyId uint64, name, picUrl, effectUrl string) error {
	activityConfig := ResProperty{Entity: mysql.Entity{ID: propertyId}}
	err := model.Db.First(&activityConfig).Error
	if err != nil {
		return err
	}
	activityConfig.Name = name
	activityConfig.PicUrl = picUrl
	activityConfig.EffectUrl = effectUrl
	return model.Db.Save(&activityConfig).Error
}

func (p *ResProperty) Get(db *gorm.DB) error {
	return db.Where(p).First(p).Error
}

func (p *ResProperty) GetAll(db *gorm.DB) (map[uint64]ResProperty, error) {
	rows := make([]ResProperty, 0)
	if err := db.Where(p).Find(&rows).Error; err != nil {
		return nil, err
	}
	result := make(map[uint64]ResProperty, 0)
	for _, i := range rows {
		result[i.ID] = i
	}
	return result, nil
}

func (p *ResPropertyAvatar) GetAll(db *gorm.DB) (map[uint64]ResPropertyAvatar, error) {
	rows := make([]ResPropertyAvatar, 0)
	if err := db.Where(p).Find(&rows).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	result := make(map[uint64]ResPropertyAvatar, 0)
	for _, i := range rows {
		result[i.ResPropertyId] = i
	}
	return result, nil
}
