package redis_key

import (
	"fmt"
	"os"
)

// 替换keyFmt中的${var}变量s
// param keyFmt 如 a_b_${var1}_${var2}
// param arg 是个数组,按照下标替换${var},越界就用var1字样
// return a_b_var1_var2
func ReplaceKey(keyFmt string, arg ...string) string {
	n := len(arg)
	if n <= 0 {
		return keyFmt
	}
	var i int
	return os.Expand(keyFmt, func(s string) (r string) {
		if i >= n {
			return s
		}
		r = arg[i]
		i++
		return
	})
}

func GetUserMedalMerge(userId uint64) string {
	return fmt.Sprintf(UserMedalMerge, userId)
}
