package country_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/_const/enum/country_e"
	"hilo-user/myerr"
)

type CountryMgrUser struct {
	mysql.Entity
	Country string
	UserId  mysql.ID
	Role    country_e.CountryMgrRole
}

// 获取国家管理人员
func GetCountryMgr(model *domain.Model, userId mysql.ID) (*CountryMgrUser, error) {
	cmu := new(CountryMgrUser)
	if err := model.Db.WithContext(model.MyContext.Context).Where("user_id = ?", userId).First(&cmu).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return cmu, nil
}

// 更新国家管理人员
func (cmu *CountryMgrUser) UpdateCountryMgr(userId mysql.ID, role country_e.CountryMgrRole, country string) *CountryMgrUser {
	cmu.UserId, cmu.Role, cmu.Country = userId, role, country
	return cmu
}

// 删除国家管理人员
func (cmu *CountryMgrUser) DeleteCountryMgr() {
	cmu.SetDel()
}
