package cp_cron

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"git.hilo.cn/hilo-common/sdk/tencentyun"
	"github.com/robfig/cron"
	"hilo-user/domain/model/cp_m"
	"hilo-user/domain/model/user_m"
)

// 纪念日
type CpAnniversaryNoticeMsg struct {
	Identifier string `json:"identifier"`
	Content    string `json:"content"`
	Date       string `json:"date"`
}

func CpAnniversaryNotice() {
	c := cron.New()
	// 1小时操作一次
	spec := "0 0 */1 * * ?"
	if !config.AppIsRelease() {
		// 测服1分钟
		spec = "0 * * * * ?"
	}
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		anniversary := cp_m.GetNeedRemindCpAnniversary(model)
		for _, v := range anniversary {
			var userIds []uint64
			userIds = append(userIds, v.UserId1, v.UserId2)
			users, err := user_m.GetUsersByIds(model, userIds)
			if err != nil || len(users) < 2 {
				model.Log.Errorf("GetUserMapByIds fail:%v", err)
				continue
			}
			data, _ := json.Marshal(CpAnniversaryNoticeMsg{
				Identifier: "CpAnniversaryNotice",
				Content:    v.Content,
				Date:       v.Date,
			})
			if err := tencentyun.BatchSendCustomMsg(model, 1, users[0].ExternalId, []string{users[1].ExternalId}, string(data), "cp纪念日"); err != nil {
				model.Log.Errorf("BatchSendCustomMsg fail:%v", err)
			}
			if err := tencentyun.BatchSendCustomMsg(model, 1, users[1].ExternalId, []string{users[0].ExternalId}, string(data), "cp纪念日"); err != nil {
				model.Log.Errorf("BatchSendCustomMsg fail:%v", err)
			}
			if err := cp_m.UpdateCpAnniversaryReminded(model, v.ID); err != nil {
				model.Log.Errorf("UpdateCpAnniversaryReminded fail:%v", err)
			}
		}
	})
	c.Start()
}
