package cp_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"time"
)

// CpAnniversary  cp纪念日
type CpAnniversary struct {
	mysql.Entity
	CpId     mysql.ID
	UserId1  mysql.ID
	UserId2  mysql.ID
	Content  string
	Date     string
	Timezone string
	IsRemind bool
	Reminded mysql.YesNo
}

// 添加cp纪念日
func AddCpAnniversary(model *domain.Model, cp CpRelationTmp, content, date, tz string, isRemind bool) error {
	return model.DB().Model(CpAnniversary{}).Create(&CpAnniversary{
		CpId:     cp.ID,
		UserId1:  cp.UserId1,
		UserId2:  cp.UserId2,
		Content:  content,
		Date:     date,
		Timezone: tz,
		IsRemind: isRemind,
		Reminded: mysql.NO,
	}).Error
}

// 更新cp纪念日
func UpdateCpAnniversary(model *domain.Model, id mysql.ID, content, date, tz string, isRemind bool) error {
	updates := map[string]interface{}{
		"content":   content,
		"date":      date,
		"timezone":  tz,
		"is_remind": isRemind,
	}
	return model.DB().Model(CpAnniversary{}).Where("id = ?", id).Updates(updates).Error
}

func DelCpAnniversary(model *domain.Model, id mysql.ID) error {
	return model.DB().Model(CpAnniversary{}).Where("id = ? ", id).Delete(&CpAnniversary{}).Error
}

// 根据用户id获取所有纪念日
func GetAllCpAnniversary(model *domain.Model, userId mysql.ID) []CpAnniversary {
	var res []CpAnniversary
	relation, exists := GetCpRelation(model, userId)
	if !exists {
		return res
	}
	if err := model.DB().Model(CpAnniversary{}).Where("cp_id = ?", relation.ID).Order("id").Find(&res).Error; err != nil {
		model.Log.Errorf("GetAllCpAnniversary fail:%v", err)
	}
	return res
}

// 获取所有需要提醒的纪念日
func GetNeedRemindCpAnniversary(model *domain.Model) []CpAnniversary {
	var res []CpAnniversary
	date := time.Now().Format("2006-01-02")
	if err := model.DB().Model(CpAnniversary{}).
		Where("`date` = ?", date).
		Where("is_remind = 1").
		Where("reminded = ?", mysql.NO).
		Find(&res).Error; err != nil {
		model.Log.Errorf("GetNeedRemindCpAnniversary fail:%v", err)
	}
	return res
}

func UpdateCpAnniversaryReminded(model *domain.Model, id mysql.ID) error {
	return model.DB().Model(CpAnniversary{}).Where("id = ?", id).Update("reminded", mysql.YES).Error
}
