package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/_const/enum/user_e"
	"time"
)

//用户Vip
type UserVip struct {
	mysql.Entity
	*domain.Model       `gorm:"-"`
	UserId              mysql.ID
	ExpireAt            time.Time          //结束时间
	Type                user_e.UserVipType //来源类型
	Platform            mysql.Platform
	VipSubscribeOrderId mysql.ID //最后的订单ID
}

// 检查某用户是否Vip
func IsVip(userId uint64) (bool, *int64, error) {
	uv, err := GetVip(mysql.Db, userId)
	if err != nil {
		return false, nil, err
	}
	if uv == nil {
		return false, nil, nil
	}
	ts := uv.ExpireAt.Unix()
	return true, &ts, nil
}

func GetVip(db *gorm.DB, userId uint64) (*UserVip, error) {
	rows := make([]UserVip, 0)
	err := db.Where("user_id = ? AND expire_at >= NOW()", userId).Find(&rows).Error
	if err != nil {
		return nil, err
	}
	if len(rows) > 0 {
		return &rows[0], nil
	}
	return nil, nil
}

func BatchGetVips(userIds []uint64) (map[uint64]*int64, error) {
	rows := make([]UserVip, 0)
	err := mysql.Db.Where("user_id IN ?", userIds).Find(&rows).Error
	if err != nil {
		return nil, err
	}

	result := make(map[uint64]*int64, 0)
	for _, i := range userIds {
		result[i] = nil
	}
	now := time.Now()
	for _, i := range rows {
		if i.ExpireAt.After(now) {
			ts := i.ExpireAt.Unix()
			result[i.UserId] = &ts
		}
	}
	return result, nil
}
