package user_r

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"github.com/gin-gonic/gin"
	"hilo-user/req"
	"hilo-user/resp"
)

// @Tags 用户
// @Summary 获取用户详细信息
// @Param token header string true "token"
// @Param timestamp header string true "时间戳"
// @Param nonce header string true "随机数字"
// @Param signature header string true "sha1加密结果"
// @Param deviceType header string true "系统类型 ios android"
// @Param deviceVersion header string true "系统版本"
// @Success 200 {object} user_cv.CvUserDetail
// @Router /v1/user/detail [get]
func UserDetail(c *gin.Context) (*mycontext.MyContext, error) {
	myContext := mycontext.CreateMyContext(c.Keys)
	userId, err := req.GetUserId(c)
	if err != nil {
		return myContext, err
	}

	model := domain.CreateModelContext(myContext)

	cvUserDetail, err := cv.GetUserDetail(model, userId, userId)
	if err != nil {
		return myContext, err
	}
	resp.ResponseOk(c, cvUserDetail)
	return myContext, nil
}
